/*
 
 Copyright (C) 2006 NTT DATA Corporation
 
 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License 
 as published by the Free Software Foundation, version 2.
 
 This program is distributed in the hope that it will be
 useful, but WITHOUT ANY WARRANTY; without even the implied 
 warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 PURPOSE.  See the GNU General Public License for more details.
 
 */

package com.clustercontrol.monitor.run.bean;

import com.clustercontrol.bean.ProcessConstant;
import com.clustercontrol.bean.ValidConstant;

/**
 * 文字列監視の判定情報を保持するクラスです。
 * 
 * @version 2.1.0
 * @since 2.1.0
 */
public class MonitorStringValueInfo
extends MonitorJudgementInfo
{
	private static final long serialVersionUID = -72068372783747219L;
	
	/** 識別キー。 */
	protected String m_identifier; 
	
	/** 順序。 */
	protected int m_orderNo = Integer.MAX_VALUE; 
	
	/** 説明。 */
	protected String m_description; 
	
	/**
	 * 処理タイプ。
	 * 
	 * @see com.clustercontrol.bean.ProcessConstant
	 */
	protected int m_processType = ProcessConstant.TYPE_YES; 
	
	/** パターンマッチ表現。 */
	protected String m_pattern; 
	
	/** 通知ID。 */
	protected String m_notifyId; 
	
	/**
	 * 有効/無効。
	 * 
	 * @see com.clustercontrol.bean.ValidConstant
	 */
	protected boolean m_validFlg = ValidConstant.BOOLEAN_VALID;
	
	
	/**
	 * コンストラクタ。
	 */
	public MonitorStringValueInfo() {
		super();
	}
	
	/**
	 * コンストラクタ。
	 * 
	 * @param monitorTypeId 監視対象ID
	 * @param monitorId 監視項目ID
	 * @param orderNo 順序
	 * @param description 説明
	 * @param processType 処理タイプ
	 * @param pattern パターンマッチ表現
	 * @param priority 重要度
	 * @param messageId メッセージID
	 * @param message メッセージ
	 * @param notifyId 通知ID
	 * @param jobRun ジョブ実行
	 * @param jobId ジョブID
	 * @param jobInhibitionFlg ジョブの通知抑制と連動
	 * @param jobFailurePriority ジョブ呼出の失敗時の重要度
	 * @param validFlg 有効/無効
	 */
	public MonitorStringValueInfo(
			String monitorTypeId, 
			String monitorId, 
			int orderNo, 
			String description, 
			int processType, 
			String pattern, 
			int priority, 
			String messageId, 
			String message, 
			String notifyId, 
			int jobRun, 
			String jobId, 
			int jobInhibitionFlg, 
			int jobFailurePriority, 
			boolean validFlg) {
		
		setMonitorTypeId(monitorTypeId);
		setMonitorId(monitorId);
		setOrderNo(orderNo);
		setDescription(description);
		setProcessType(processType);
		setPattern(pattern);
		setPriority(priority);
		setMessageId(messageId);
		setMessage(message);
		setNotifyId(notifyId);
		setJobRun(jobRun);
		setJobId(jobId);
		setJobInhibitionFlg(jobInhibitionFlg);
		setJobFailurePriority(jobFailurePriority);
		setValidFlg(validFlg);
	}
	
	/**
	 * コンストラクタ。
	 * 
	 * @param otherData コピー元の文字列監視の判定情報
	 */
	public MonitorStringValueInfo(MonitorStringValueInfo otherData) {
		
		setIdentifier(otherData.getIdentifier());
		setMonitorTypeId(otherData.getMonitorTypeId());
		setMonitorId(otherData.getMonitorId());
		setOrderNo(otherData.getOrderNo());
		setDescription(otherData.getDescription());
		setProcessType(otherData.getProcessType());
		setPattern(otherData.getPattern());
		setPriority(otherData.getPriority());
		setMessageId(otherData.getMessageId());
		setMessage(otherData.getMessage());
		setNotifyId(otherData.getNotifyId());
		setJobRun(otherData.getJobRun());
		setJobId(otherData.getJobId());
		setJobInhibitionFlg(otherData.getJobInhibitionFlg());
		setJobFailurePriority(otherData.getJobFailurePriority());
		setValidFlg(otherData.isValidFlg());
	}
	
	/**
	 * 説明を返します。
	 * 
	 * @return 説明
	 */
	public String getDescription() {
		return m_description;
	}
	
	/**
	 * 説明を設定します。
	 * 
	 * @param description 説明
	 */
	public void setDescription(String description) {
		this.m_description = description;
	}
	
	/**
	 * 識別子を返します。
	 * 
	 * @return 識別子
	 */
	public String getIdentifier() {
		return m_identifier;
	}
	
	/**
	 * 識別子を設定します。
	 * 
	 * @param identifier 識別子
	 */
	public void setIdentifier(String identifier) {
		this.m_identifier = identifier;
	}
	
	/**
	 * 通知IDを返します。
	 * 
	 * @return 通知ID
	 */
	public String getNotifyId() {
		return m_notifyId;
	}
	
	/**
	 * 通知IDを設定します。
	 * 
	 * @param notifyId 通知ID
	 */
	public void setNotifyId(String notifyId) {
		this.m_notifyId = notifyId;
	}
	
	/**
	 * 順序を返します。
	 * 
	 * @return 順序
	 */
	public int getOrderNo() {
		return m_orderNo;
	}
	
	/**
	 * 順序を設定します。
	 * 
	 * @param orderNo 順序
	 */
	public void setOrderNo(int orderNo) {
		this.m_orderNo = orderNo;
	}
	
	/**
	 * パターンマッチ表現を返します。
	 * 
	 * @return パターンマッチ表現
	 */
	public String getPattern() {
		return m_pattern;
	}
	
	/**
	 * パターンマッチ表現を設定します。
	 * 
	 * @param pattern パターンマッチ表現
	 */
	public void setPattern(String pattern) {
		this.m_pattern = pattern;
	}
	
	/**
	 * 処理タイプを返します。
	 * 
	 * @return 処理タイプ
	 * 
	 * @see com.clustercontrol.bean.ProcessConstant
	 */
	public int getProcessType() {
		return m_processType;
	}
	
	/**
	 * 処理タイプを設定します。
	 * 
	 * @param processType 処理タイプ
	 * 
	 * @see com.clustercontrol.bean.ProcessConstant
	 */
	public void setProcessType(int processType) {
		this.m_processType = processType;
	}
	
	/**
	 * 有効/無効を返します。
	 * 
	 * @return 有効/無効
	 * 
	 * @see com.clustercontrol.bean.ValidConstant
	 */
	public boolean isValidFlg() {
		return m_validFlg;
	}
	
	/**
	 * 有効/無効を設定します。
	 * 
	 * @param validFlg 有効/無効
	 * 
	 * @see com.clustercontrol.bean.ValidConstant
	 */
	public void setValidFlg(boolean validFlg) {
		this.m_validFlg = validFlg;
	}
}
