/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.calendar.action;

import java.rmi.AccessException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Locale;

import org.eclipse.jface.dialogs.MessageDialog;

import com.clustercontrol.calendar.ejb.session.CalendarController;
import com.clustercontrol.calendar.util.EjbConnectionManager;
import com.clustercontrol.util.Messages;

/**
 * カレンダ曜日別情報一覧テーブル定義取得クラス
 * 
 * @version 2.0.0
 * @since 2.0.0
 */
public class GetWeekdayInfoListTableDefine {

    // ----- instance メソッド ----- //

    /**
     * カレンダ曜日別情報一覧テーブル定義を返します。
     * 
     * @return
     */
    public static ArrayList get() {
		CalendarController calendar = 
			EjbConnectionManager.getConnectionManager().getCalendarController();
		
        ArrayList tableDefine = null;
        try {
            tableDefine = calendar
                    .getWeekdayListTableDefine(Locale.getDefault());
        } catch (RemoteException e) {
			if(e instanceof AccessException){
				// アクセス権なしの場合、エラーダイアログを表示する
	            MessageDialog.openInformation(null, Messages.getString("message"),
	                    Messages.getString("message.accesscontrol.16"));
			}
        }
        return tableDefine;
    }
}