/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.calendar.ejb.session;

import java.rmi.RemoteException;
import java.security.Principal;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;

import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.ejb.SessionContext;
import javax.naming.NamingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.swt.SWT;

import com.clustercontrol.bean.Property;
import com.clustercontrol.bean.TableColumnInfo;
import com.clustercontrol.calendar.bean.AddListTableDefine;
import com.clustercontrol.calendar.bean.CalendarListTableDefine;
import com.clustercontrol.calendar.bean.ScheduleTableConstant;
import com.clustercontrol.calendar.bean.WeekdayListTableDefine;
import com.clustercontrol.calendar.factory.AddProperty;
import com.clustercontrol.calendar.factory.CalendarProperty;
import com.clustercontrol.calendar.factory.ModifyCalendar;
import com.clustercontrol.calendar.factory.SelectCalendar;
import com.clustercontrol.calendar.factory.WeekdayProperty;
import com.clustercontrol.util.Messages;

/**
 *
 * <!-- begin-user-doc --> A generated session bean <!-- end-user-doc --> *
 *
 * <!-- begin-xdoclet-definition --> 
 * @ejb.bean name="CalendarController"	
 *           jndi-name="CalendarController"
 *           type="Stateless" 
 *           transaction-type="Container"
 * 
 * @jboss.depends name="jboss.j2ee:service=EJB,jndiName=AccessController"
 * 
 * @ejb.permission
 *     unchecked="true"
 *     method-intf="Home"
 *     
 * @ejb.permission
 *     unchecked="true"
 *     method-intf="LocalHome"
 *     
 * @ejb.permission
 *     unchecked="true"
 *     method-intf="Local"
 * 
 * <!-- end-xdoclet-definition --> 
 * @generated
 */
public abstract class CalendarControllerBean implements javax.ejb.SessionBean {
    protected static Log m_log = LogFactory.getLog( CalendarControllerBean.class );
    
	@SuppressWarnings("unused")
	private SessionContext m_context;
	
	public void setSessionContext(SessionContext ctx) throws EJBException, RemoteException {
		m_context = ctx;
	}
	
	/**
	 * カレンダ一覧テーブル定義取得
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     unchecked="true"
     *     method-intf="Remote"
	 * 
	 * @param local
	 * @return TableColumnInfoの配列
	 */
	@SuppressWarnings("unchecked")
	public ArrayList getCalendarListTableDefine(Locale locale) {
		//テーブル定義配列
		ArrayList tableDefine = new ArrayList();
		
		tableDefine.add(CalendarListTableDefine.CALENDAR_ID, 
				new TableColumnInfo(Messages.getString("calendar.id", locale), TableColumnInfo.NONE, 100, SWT.LEFT));
		tableDefine.add(CalendarListTableDefine.CALENDAR_NAME, 
				new TableColumnInfo(Messages.getString("calendar.name", locale), TableColumnInfo.NONE, 100, SWT.LEFT));
		tableDefine.add(CalendarListTableDefine.VALID_TIME_FROM, 
				new TableColumnInfo(Messages.getString("valid.time", locale) + "(" + Messages.getString("start", locale) + ")", 
						TableColumnInfo.NONE, 150, SWT.LEFT));
		tableDefine.add(CalendarListTableDefine.VALID_TIME_TO, 
				new TableColumnInfo(Messages.getString("valid.time", locale) + "(" + Messages.getString("end", locale) + ")", 
						TableColumnInfo.NONE, 150, SWT.LEFT));
		tableDefine.add(CalendarListTableDefine.DESCRIPTION, 
				new TableColumnInfo(Messages.getString("description", locale), TableColumnInfo.NONE, 150, SWT.LEFT));
		tableDefine.add(CalendarListTableDefine.CREATOR_NAME, 
				new TableColumnInfo(Messages.getString("creator.name", locale), TableColumnInfo.NONE, 100, SWT.LEFT));
		tableDefine.add(CalendarListTableDefine.CREATE_TIME, 
				new TableColumnInfo(Messages.getString("create.time", locale), TableColumnInfo.NONE, 150, SWT.LEFT));
		tableDefine.add(CalendarListTableDefine.MODIFIER_NAME, 
				new TableColumnInfo(Messages.getString("modifier.name", locale), TableColumnInfo.NONE, 100, SWT.LEFT));
		tableDefine.add(CalendarListTableDefine.MODIFY_TIME, 
				new TableColumnInfo(Messages.getString("update.time", locale), TableColumnInfo.NONE, 150, SWT.LEFT));
		tableDefine.add(CalendarListTableDefine.MODIFY_TIME + 1, 
				new TableColumnInfo("", TableColumnInfo.CHECKBOX, 0, SWT.LEFT));
		
		return tableDefine;
	}
	
	/**
	 * カレンダ曜日別情報一覧テーブル定義取得
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     unchecked="true"
     *     method-intf="Remote"
	 * 
	 * @param local
	 * @return TableColumnInfoの配列
	 */
	@SuppressWarnings("unchecked")
	public ArrayList getWeekdayListTableDefine(Locale locale) {
		//テーブル定義配列
		ArrayList tableDefine = new ArrayList();
		
		tableDefine.add(WeekdayListTableDefine.WEEKDAY, 
				new TableColumnInfo(Messages.getString("weekday", locale), TableColumnInfo.DAY_OF_WEEK, 80, SWT.LEFT));
		tableDefine.add(WeekdayListTableDefine.TIME_FROM, 
				new TableColumnInfo(Messages.getString("timestamp", locale) + "(" + Messages.getString("start", locale) + ")", 
						TableColumnInfo.NONE, 100, SWT.LEFT));
		tableDefine.add(WeekdayListTableDefine.TIME_TO, 
				new TableColumnInfo(Messages.getString("timestamp", locale) + "(" + Messages.getString("end", locale) + ")", 
						TableColumnInfo.NONE, 100, SWT.LEFT));
		tableDefine.add(WeekdayListTableDefine.DESCRIPTION, 
				new TableColumnInfo(Messages.getString("description", locale), TableColumnInfo.NONE, 150, SWT.LEFT));
		tableDefine.add(WeekdayListTableDefine.CREATOR_NAME, 
				new TableColumnInfo(Messages.getString("creator.name", locale), TableColumnInfo.NONE, 100, SWT.LEFT));
		tableDefine.add(WeekdayListTableDefine.CREATE_TIME, 
				new TableColumnInfo(Messages.getString("create.time", locale), TableColumnInfo.NONE, 150, SWT.LEFT));
		tableDefine.add(WeekdayListTableDefine.MODIFIER_NAME, 
				new TableColumnInfo(Messages.getString("modifier.name", locale), TableColumnInfo.NONE, 100, SWT.LEFT));
		tableDefine.add(WeekdayListTableDefine.MODIFY_TIME, 
				new TableColumnInfo(Messages.getString("update.time", locale), TableColumnInfo.NONE, 150, SWT.LEFT));

		return tableDefine;
	}
	
	/**
	 * カレンダ追加情報一覧テーブル定義取得
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     unchecked="true"
     *     method-intf="Remote"
	 * 
	 * @param local
	 * @return TableColumnInfoの配列
	 */
	@SuppressWarnings("unchecked")
	public ArrayList getAddListTableDefine(Locale locale) {
		//テーブル定義配列
		ArrayList tableDefine = new ArrayList();
		
		tableDefine.add(AddListTableDefine.EXECUTE, 
				new TableColumnInfo(Messages.getString("run", locale), TableColumnInfo.CHECKBOX, 50, SWT.LEFT));
		tableDefine.add(AddListTableDefine.TIME_FROM, 
				new TableColumnInfo(Messages.getString("time", locale) + "(" + Messages.getString("start", locale) + ")", 
						TableColumnInfo.NONE, 150, SWT.LEFT));
		tableDefine.add(AddListTableDefine.TIME_TO, 
				new TableColumnInfo(Messages.getString("time", locale) + "(" + Messages.getString("end", locale) + ")", 
						TableColumnInfo.NONE, 150, SWT.LEFT));
		tableDefine.add(AddListTableDefine.DESCRIPTION, 
				new TableColumnInfo(Messages.getString("description", locale), TableColumnInfo.NONE, 150, SWT.LEFT));
		tableDefine.add(WeekdayListTableDefine.CREATOR_NAME, 
				new TableColumnInfo(Messages.getString("creator.name", locale), TableColumnInfo.NONE, 100, SWT.LEFT));
		tableDefine.add(WeekdayListTableDefine.CREATE_TIME, 
				new TableColumnInfo(Messages.getString("create.time", locale), TableColumnInfo.NONE, 150, SWT.LEFT));
		tableDefine.add(WeekdayListTableDefine.MODIFIER_NAME, 
				new TableColumnInfo(Messages.getString("modifier.name", locale), TableColumnInfo.NONE, 100, SWT.LEFT));
		tableDefine.add(WeekdayListTableDefine.MODIFY_TIME, 
				new TableColumnInfo(Messages.getString("update.time", locale), TableColumnInfo.NONE, 150, SWT.LEFT));

		return tableDefine;
	}
	
	/**
	 * カレンダ予定テーブル定義取得
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     unchecked="true"
     *     method-intf="Remote"
	 * 
	 * @param base
	 * @param locale
	 * @return TableColumnInfoの配列
	 */
	@SuppressWarnings("unchecked")
	public ArrayList getScheduleTableDefine(Date base, Locale locale) {
		//テーブル定義配列
		ArrayList tableDefine = new ArrayList();
		
		tableDefine.add(0, 
				new TableColumnInfo(Messages.getString("calendar.id", locale), TableColumnInfo.NONE, 0, SWT.LEFT));
		for(int i = 0; i < ScheduleTableConstant.DAYS; i++){
			Calendar baseCalendar = Calendar.getInstance();
			baseCalendar.setTime(base);
			baseCalendar.add(Calendar.DAY_OF_MONTH, i);
			Date work = baseCalendar.getTime();
			tableDefine.add(i+1, 
					new TableColumnInfo(
							DateFormat.getDateInstance(DateFormat.SHORT, locale).format(work), 
							TableColumnInfo.SCHEDULE_ON_OFF, 70, SWT.LEFT));			
		}
		
		return tableDefine;
	}
	
	/**
	 * カレンダ一覧取得
	 * 
	 * @ejb.interface-method
     *     
	 * @ejb.permission
     *     role-name="CalendarRead"
     *     method-intf="Remote"
     *     
	 * @jboss.method-attributes
	 *     read-only="true"
	 * 
	 * @return オブジェクトの2次元配列
	 * @throws FinderException
	 * @throws NamingException
	 */
	public ArrayList getCalendarList() throws FinderException, NamingException {

		ArrayList list = null;
		try {
			SelectCalendar select = new SelectCalendar();
			list = select.getCalendarList();
		} catch (FinderException e) {
			m_log.debug("getCalendarList() -> " + e.getMessage());
			throw e;
		} catch (NamingException e) {
			throw e;
		}

		return list;
	}
	
	/**
	 * カレンダ曜日別情報一覧取得
	 * 
	 * @ejb.interface-method
     *     
	 * @ejb.permission
     *     role-name="CalendarRead"
     *     method-intf="Remote"
     *     
	 * @jboss.method-attributes
	 *     read-only="true"
	 * 
	 * @return オブジェクトの2次元配列
	 * @throws FinderException
	 * @throws NamingException
	 */
	public ArrayList getWeekdayList(String id) throws FinderException, NamingException {

		ArrayList list = null;
		try {
			SelectCalendar select = new SelectCalendar();
			list = select.getWeekdayList(id);
		} catch (FinderException e) {
			m_log.debug("getWeekdayList() -> " + e.getMessage());
			throw e;
		} catch (NamingException e) {
			throw e;
		}

		return list;
	}
	
	/**
	 * カレンダ追加情報一覧取得
	 * 
	 * @ejb.interface-method
     *     
	 * @ejb.permission
     *     role-name="CalendarRead"
     *     method-intf="Remote"
     *     
	 * @jboss.method-attributes
	 *     read-only="true"
	 * 
	 * @return オブジェクトの2次元配列
	 * @throws FinderException
	 * @throws NamingException
	 */
	public ArrayList getAddList(String id) throws FinderException, NamingException {

		ArrayList list = null;
		try {
			SelectCalendar select = new SelectCalendar();
			list = select.getAddList(id);
		} catch (FinderException e) {
			m_log.debug("getAddList() -> " + e.getMessage());
			throw e;
		} catch (NamingException e) {
			throw e;
		}

		return list;
	}
	
	/**
	 * カレンダ予定取得
	 * 
	 * @ejb.interface-method
     *     
	 * @ejb.permission
     *     role-name="CalendarRead"
     *     method-intf="Remote"
     *     
	 * @jboss.method-attributes
	 *     read-only="true"
	 * 
	 * @return オブジェクトの2次元配列
	 * @throws FinderException
	 * @throws NamingException
	 */
	public ArrayList getSchedule(Date base) throws FinderException, NamingException {

		SelectCalendar select = new SelectCalendar();
		ArrayList list = select.getSchedule(base);

		return list;
	}
	
	/**
	 * カレンダ用プロパティ取得
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     role-name="CalendarWrite"
     *     method-intf="Remote"
     *     
	 * @jboss.method-attributes
	 *     read-only="true"
	 * 
	 * @param id
	 * @param mode
	 * @param local
	 * @return
	 * @throws FinderException
	 * @throws NamingException
	 */
	public Property getCalendarProperty(String id, int mode, Locale locale) throws FinderException, NamingException {
		try {
			return new CalendarProperty().getProperty(id, mode, locale);
		} catch (FinderException e) {
			m_log.debug("getCalendarProperty() -> " + e.getMessage());
			throw e;
		} catch (NamingException e) {
			throw e;
		}
	}
	
	/**
	 * カレンダ追加
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     role-name="CalendarWrite"
     *     method-intf="Remote"
	 * 
	 * 
	 * @param property
	 * @throws CreateException 
	 * @throws NamingException 
	 */
	public void addCalendar(Property property) throws NamingException, CreateException {

		Principal pri = m_context.getCallerPrincipal();
			
		ModifyCalendar modify = new ModifyCalendar();
		modify.addCalendar(property, pri.getName());

	}
	
	/**
	 * カレンダ変更
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     role-name="CalendarWrite"
     *     method-intf="Remote"
	 * 
	 * @param property
	 * @throws FinderException 
	 * @throws NamingException 
	 */
	public void modifyCalendar(Property property) throws NamingException, FinderException {
		try {
			Principal pri = m_context.getCallerPrincipal();
			
			ModifyCalendar modify = new ModifyCalendar();
			modify.modifyCalendar(property, pri.getName());
		} catch (NamingException e) {
			throw e;
		} catch (FinderException e) {
			m_log.debug("modifyCalendar() -> " + e.getMessage());
			throw e;
		}
	}
		
	/**
	 * カレンダ削除
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     role-name="CalendarWrite"
     *     method-intf="Remote"
	 * 
	 * @param id
	 * @throws FinderException 
	 * @throws RemoveException 
	 * @throws NamingException 
	 */
	public void deleteCalendar(String id) throws NamingException, RemoveException, FinderException  {
		try {
			ModifyCalendar modify = new ModifyCalendar();
			modify.deleteCalendar(id);
		} catch (NamingException e) {
			throw e;
		} catch (RemoveException e) {
			throw e;
		} catch (FinderException e) {
			m_log.debug("deleteCalendar() -> " + e.getMessage());
			throw e;
		}
	}
	
	/**
	 * カレンダ曜日別情報用プロパティ取得
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     role-name="CalendarWrite"
     *     method-intf="Remote"
	 * 
	 * @jboss.method-attributes
	 *     read-only="true"
	 * 
	 * @param id
	 * @param mode
	 * @param local
	 * @return
	 * @throws FinderException
	 * @throws NamingException
	 */
	public Property getWeekdayProperty(String id, Integer weekday, Date from, Date to, int mode, Locale locale) throws FinderException, NamingException {
		try {
			return new WeekdayProperty().getProperty(id, weekday, from, to, mode, locale);
		} catch (FinderException e) {
			m_log.debug("getWeekdayProperty() -> " + e.getMessage());
			throw e;
		} catch (NamingException e) {
			throw e;
		}
	}
	
	/**
	 * カレンダ曜日別情報追加
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     role-name="CalendarWrite"
     *     method-intf="Remote"
	 * 
	 * @param id
	 * @param property
	 * @throws FinderException 
	 * @throws CreateException 
	 * @throws NamingException 
	 */
	public void addWeekday(String id, Property property) throws NamingException, CreateException, FinderException {
		try {
			Principal pri = m_context.getCallerPrincipal();
			
			ModifyCalendar modify = new ModifyCalendar();
			modify.addWeekday(id, property, pri.getName());
		} catch (NamingException e) {
			throw e;
		} catch (CreateException e) {
			throw e;
		} catch (FinderException e) {
			m_log.debug("addWeekday() -> " + e.getMessage());
			throw e;
		}
	}
	
	/**
	 * カレンダ曜日別情報変更
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     role-name="CalendarWrite"
     *     method-intf="Remote"
	 * 
	 * @param id
	 * @param weekday
	 * @param from
	 * @param to
	 * @param property
	 * @throws NamingException
	 * @throws FinderException
	 * @throws RemoveException
	 * @throws CreateException
	 */
	public void modifyWeekday(String id, Integer weekday, Date from, Date to, Property property) throws NamingException, FinderException, RemoveException, CreateException {
		try {
			Principal pri = m_context.getCallerPrincipal();
			
			ModifyCalendar modify = new ModifyCalendar();
			modify.modifyWeekday(id, weekday, from, to, property, pri.getName());
		} catch (NamingException e) {
			throw e;
		} catch (RemoveException e) {
			throw e;
		} catch (CreateException e) {
			throw e;
		} catch (FinderException e) {
			m_log.debug("modifyWeekday() -> " + e.getMessage());
			throw e;
		}
	}
		
	/**
	 * カレンダ曜日別情報削除
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     role-name="CalendarWrite"
     *     method-intf="Remote"
	 * 
	 * @param id
	 * @throws FinderException 
	 * @throws RemoveException 
	 * @throws NamingException 
	 */
	public void deleteWeekday(String id, Integer weekday, Date from, Date to) throws NamingException, RemoveException, FinderException  {
		try {
			ModifyCalendar modify = new ModifyCalendar();
			modify.deleteWeekday(id, weekday, from, to);
		} catch (NamingException e) {
			throw e;
		} catch (RemoveException e) {
			throw e;
		} catch (FinderException e) {
			m_log.debug("deleteWeekday() -> " + e.getMessage());
			throw e;
		}
	}
	
	/**
	 * カレンダ追加情報用プロパティ取得
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     role-name="CalendarWrite"
     *     method-intf="Remote"
	 * 
	 * @jboss.method-attributes
	 *     read-only="true"
	 * 
	 * @param id
	 * @param mode
	 * @param local
	 * @return
	 * @throws FinderException
	 * @throws NamingException
	 */
	public Property getAddInfoProperty(String id, Date from, Date to, int mode, Locale locale) throws FinderException, NamingException {
		try {
			return new AddProperty().getProperty(id, from, to, mode, locale);
		} catch (FinderException e) {
			m_log.debug("getAddInfoProperty() -> " + e.getMessage());
			throw e;
		} catch (NamingException e) {
			throw e;
		}
	}
	
	/**
	 * カレンダ追加情報追加
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     role-name="CalendarWrite"
     *     method-intf="Remote"
	 * 
	 * @param id
	 * @param property
	 * @throws FinderException 
	 * @throws CreateException 
	 * @throws NamingException 
	 */
	public void addAddInfo(String id, Property property) throws NamingException, CreateException, FinderException {
		try {
			Principal pri = m_context.getCallerPrincipal();
			
			ModifyCalendar modify = new ModifyCalendar();
			modify.addAddInfo(id, property, pri.getName());
		} catch (NamingException e) {
			throw e;
		} catch (CreateException e) {
			throw e;
		} catch (FinderException e) {
			m_log.debug("addAddInfo() -> " + e.getMessage());
			throw e;
		}
	}
	
	/**
	 * カレンダ追加情報変更
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     role-name="CalendarWrite"
     *     method-intf="Remote"
	 * 
	 * @param id
	 * @param from
	 * @param to
	 * @param property
	 * @throws NamingException
	 * @throws FinderException
	 * @throws RemoveException
	 * @throws CreateException
	 */
	public void modifyAddInfo(String id, Date from, Date to, Property property) throws NamingException, FinderException, RemoveException, CreateException {
		try {
			Principal pri = m_context.getCallerPrincipal();
			
			ModifyCalendar modify = new ModifyCalendar();
			modify.modifyAddInfo(id, from, to, property, pri.getName());
		} catch (NamingException e) {
			throw e;
		} catch (RemoveException e) {
			throw e;
		} catch (CreateException e) {
			throw e;
		} catch (FinderException e) {
			m_log.debug("modifyAddInfo() -> " + e.getMessage());
			throw e;
		}
	}
		
	/**
	 * カレンダ追加情報削除
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     role-name="CalendarWrite"
     *     method-intf="Remote"
	 * 
	 * @param id
	 * @throws FinderException 
	 * @throws RemoveException 
	 * @throws NamingException 
	 */
	public void deleteAddInfo(String id, Date from, Date to) throws NamingException, RemoveException, FinderException  {
		try {
			ModifyCalendar modify = new ModifyCalendar();
			modify.deleteAddInfo(id, from, to);
		} catch (NamingException e) {
			throw e;
		} catch (RemoveException e) {
			throw e;
		} catch (FinderException e) {
			m_log.debug("deleteAddInfo() -> " + e.getMessage());
			throw e;
		}
	}
	
	/**
	 * カレンダ実行チェック
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.transaction type="RequiresNew"
	 * 
	 * @ejb.permission
     *     role-name="CalendarRead"
     *     method-intf="Remote"
     *     
	 * @ejb.permission
     *     role-name="JobManagementRead"
     *     method-intf="Remote"
	 * 
	 * @jboss.method-attributes
	 *     read-only="true"
	 * 
	 * @param id
	 * @param checkTimestamp
	 * @return
	 * @throws FinderException
	 * @throws NamingException
	 */
	public Boolean isRun(String id, Date checkTimestamp) throws FinderException, NamingException {
		try {
			SelectCalendar select = new SelectCalendar();
			return select.isRun(id, checkTimestamp);
		} catch (FinderException e) {
			m_log.debug("isRun() -> " + e.getMessage());
			throw e;
		} catch (NamingException e) {
			throw e;
		}
	}
	
	/**
	 * カレンダIDリスト取得チェック
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     unchecked="true"
     *     method-intf="Remote"
	 * 
	 * @jboss.method-attributes
	 *     read-only="true"
	 * 
	 * @param id
	 * @param checkTimestamp
	 * @throws FinderException
	 * @throws NamingException
	 */
	public ArrayList getCalendarIdList() throws FinderException, NamingException {
		try {
			SelectCalendar select = new SelectCalendar();
			return select.getCalendarIdList();
		} catch (FinderException e) {
			m_log.debug("getCalendarIdList() -> " + e.getMessage());
			throw e;
		} catch (NamingException e) {
			throw e;
		}
	}
}
