/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.agent.util;

import java.util.Date;
import java.util.Hashtable;

import com.clustercontrol.jobmanagement.bean.CommandTypeConstant;
import com.clustercontrol.jobmanagement.message.RunInstructionInfo;

/**
 * 実行履歴ユーティリティクラス
 * 
 * @version 2.1.0
 * @since 2.1.0
 */
public class RunHistoryUtil {

	/**
	 * 実行履歴追加
	 * @param info
	 * @param runHistory
	 * @param startDate
	 */
	public static void addRunHistory(RunInstructionInfo info, Hashtable<String, Date> runHistory, Date startDate) {
		runHistory.put(getKey(info), startDate);
	}
	 
	/**
	 * 実行履歴削除
	 * @param info
	 * @param runHistory
	 */
	public static void delRunHistory(RunInstructionInfo info, Hashtable<String, Date> runHistory) {
		if(info.getCommandType() == CommandTypeConstant.DELETE_NORMAL_HISTORY)
			info.setCommandType(CommandTypeConstant.NORMAL);
		else if(info.getCommandType() == CommandTypeConstant.DELETE_STOP_HISTORY)
			info.setCommandType(CommandTypeConstant.STOP);
		
		runHistory.remove(getKey(info));
	}
	
	/**
	 * 実行履歴検索
	 * @param info
	 * @param runHistory
	 * @return
	 */
	public static Date findRunHistory(RunInstructionInfo info, Hashtable<String, Date> runHistory) {
		Date startDate = runHistory.get(getKey(info));
		return startDate;
	}
	
	/**
	 * 実行履歴用Key作成
	 * @param info
	 * @return
	 */
	protected static String getKey(RunInstructionInfo info) {
		return info.getSessionId() + "," + info.getJobId() + "," + info.getCommandType();
	}
}
