/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.accesscontrol.ejb.entity;

import java.util.Collection;
import java.util.Date;
import java.util.List;

import javax.ejb.FinderException;
import javax.naming.NamingException;

/**
 * UserのBMP Entity Beanです。
 * 
 * @ejb.bean name="User"
 *	   jndi-name="User"
 *	   type="BMP"
 *
 * @ejb.dao class="com.clustercontrol.accesscontrol.dao.UserDAO"
 *     impl-class="com.clustercontrol.accesscontrol.dao.UserDAOImpl"
 * 
 * @ejb.permission
 *     unchecked="true"
 *     
 * @see com.clustercontrol.accesscontrol.dao.UserDAO
 * @see com.clustercontrol.accesscontrol.dao.UserDAOImpl
 */
public abstract class UserBean implements javax.ejb.EntityBean {
	/** DN */
	public String dn;
	/** ユーザID */
	public String uid;
	/** ユーザ名 */
	public String cn;
	/** 未使用 */
	public String sn;
	/** パスワード */
	public String password;
	/** 説明 */
	public String description;
	/** 新規作成ユーザ */
	public String creatorsName;
	/** 作成日時 */
	public Date createTimestamp;
	/** 最終更新ユーザ */
	public String modifiersName;
	/** 最終更新日時 */
	public Date modifyTimestamp;
	
	/**
	 * DNを返します。
	 * 
	 * @ejb.persistence
	 * @ejb.pk-field
	 * @ejb.interface-method
	 * 
	 * @return DN
	 */
	public String getDn() {
		return dn;
	}
	/**
	 * DNを設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param dn DN
	 */
	public void setDn(String dn) {
		this.dn = dn;
	}
	/**
	 * ユーザIDを返します。
	 * 
	 * @ejb.persistence
	 * @ejb.interface-method
	 * 
	 * @return ユーザID
	 */
	public String getUid() {
		return uid;
	}
	/**
	 * ユーザIDを設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param uid ユーザID
	 */
	public void setUid(String uid) {
		this.uid = uid;
	}
	/**
	 * ユーザ名を返します。
	 * 
	 * @ejb.persistence
	 * @ejb.interface-method
	 * 
	 * @return ユーザ名
	 */
	public String getCn() {
		return cn;
	}
	/**
	 * ユーザ名を設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param cn ユーザ名
	 */
	public void setCn(String cn) {
		this.cn = cn;
	}
	/**
	 * SN（未使用）を返します。
	 * 
	 * @ejb.persistence
	 * @ejb.interface-method
	 * 
	 * @return SN（未使用）
	 */
	public String getSn() {
		return sn;
	}
	/**
	 * SN（未使用）を設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param sn SN（未使用）
	 */
	public void setSn(String sn) {
		this.sn = sn;
	}
	/**
	 * パスワードを返します。
	 * 
	 * @ejb.persistence
	 * @ejb.interface-method
	 * 
	 * @return パスワード
	 */
	public String getPassword() {
		return password;
	}
	/**
	 * パスワードを設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param password パスワード
	 */
	public void setPassword(String password) {
		this.password = password;
	}
	/**
	 * 説明を返します。
	 * 
	 * @ejb.persistence
	 * @ejb.interface-method
	 * 
	 * @return 説明
	 */
	public String getDescription() {
		return description;
	}
	/**
	 * 説明を設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param description 説明
	 */
	public void setDescription(String description) {
		this.description = description;
	}
	/**
	 * 作成日時を返します。
	 * 
	 * @ejb.persistence
	 * @ejb.interface-method
	 * 
	 * @return 作成日時
	 */
	public Date getCreateTimestamp() {
		return createTimestamp;
	}
	/**
	 * 作成日時を設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param createTimestamp 作成日時
	 */
	public void setCreateTimestamp(Date createTimestamp) {
		this.createTimestamp = createTimestamp;
	}
	/**
	 * 新規作成ユーザを返します。
	 * 
	 * @ejb.persistence
	 * @ejb.interface-method
	 * 
	 * @return 新規作成ユーザ
	 */
	public String getCreatorsName() {
		return creatorsName;
	}
	/**
	 * 新規作成ユーザを設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param creatorsName 新規作成ユーザ
	 */
	public void setCreatorsName(String creatorsName) {
		this.creatorsName = creatorsName;
	}
	/**
	 * 最終更新ユーザを返します。
	 * 
	 * @ejb.persistence
	 * @ejb.interface-method
	 * 
	 * @return 最終更新ユーザ
	 */
	public String getModifiersName() {
		return modifiersName;
	}
	/**
	 * 最終更新ユーザを設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param modifiersName 最終更新ユーザ
	 */
	public void setModifiersName(String modifiersName) {
		this.modifiersName = modifiersName;
	}
	/**
	 * 最終更新日時を返します。
	 * 
	 * @ejb.persistence
	 * @ejb.interface-method
	 * 
	 * @return 最終更新日時
	 */
	public Date getModifyTimestamp() {
		return modifyTimestamp;
	}
	/**
	 * 最終更新日時を設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param modifyTimestamp 最終更新日時
	 */
	public void setModifyTimestamp(Date modifyTimestamp) {
		this.modifyTimestamp = modifyTimestamp;
	}
	/**
	 * Userを作成します。
	 * 
	 * @ejb.create-method 
	 * 
	 * @param uid ユーザID
	 * @return プライマリーキー
	 * @throws javax.ejb.CreateException
	 */
	public UserPK ejbCreate(String uid) throws javax.ejb.CreateException {
		setUid(uid);
		return null;
	}
	/**
	 * プライマリキーに一致するUserを検索します。
	 * 
	 * @param pk プライマリキー
	 * @return プライマリキー
	 * @throws FinderException
	 * 
	 * @see com.clustercontrol.accesscontrol.dao.UserDAOImpl#findByPrimaryKey(UserPK)
	 */
	public UserPK ejbFindByPrimaryKey(UserPK pk) throws FinderException {
		return null;
	}
	/**
	 * ユーザIDに一致するUserを検索します。
	 * 
	 * @param uid ユーザID
	 * @return プライマリキー
	 * @throws FinderException
	 * 
	 * @see com.clustercontrol.accesscontrol.dao.UserDAOImpl#findByUid(String)
	 */
	public UserPK ejbFindByUid(String uid) throws FinderException {
		return null;
	}
	/**
	 * 全てのUserを検索します。
	 * 
	 * @return プライマリキーのコレクション
	 * @throws FinderException
	 * 
	 * @see com.clustercontrol.accesscontrol.dao.UserDAOImpl#findAll()
	 */
	public Collection ejbFindAll() throws FinderException{ 
		return null; 
	}
	/**
	 * 複数のUserを検索します。
	 * 引数で指定された値で、LDAPを検索します。<BR>
	 * 引数：ユーザID、ユーザ名、説明、アクセス権限リスト
	 * 
	 * @param uid ユーザID
	 * @param name ユーザ名
	 * @param description 説明
	 * @param accessList アクセス権限リスト
	 * @return プライマリキーのコレクション
	 * @throws FinderException
	 * 
	 * @see com.clustercontrol.accesscontrol.dao.UserDAOImpl#findUser(String, String, String, List)
	 */
	public Collection ejbFindUser(
			String uid, 
			String name, 
			String description, 
			List accessList) throws FinderException{ 
		return null; 
	}
	
	/**
	 * Userが属しているRoleを取得します。
	 * 
	 * @ejb.interface-method view-type="local"
	 * @return Roleのコレクション
	 * @throws FinderException
	 */
	public Collection getRoles() throws FinderException{ 
		Collection collection = null;
		try {
			collection = RoleUtil.getLocalHome().findByMember(getDn());
		} catch (FinderException e) {
		} catch (NamingException e) {
		}
		return collection;
	}
}
