/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mq.xml;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.jboss.mq.xml.XElementConsumer;
import org.jboss.mq.xml.XElementException;
import org.jboss.mq.xml.XElementProducer;
import org.xml.sax.Attributes;
import sun.io.CharToByteUTF8;
import sun.io.MalformedInputException;

public class XElement {
    private XElement parent = null;
    private String name = null;
    private Hashtable metadata = new Hashtable();
    private Vector contents = new Vector();
    private static final String nl = System.getProperty("line.separator");

    public XElement(String objectName) {
        if (objectName == null) {
            throw new NullPointerException();
        }
        this.name = objectName;
        this.contents.addElement(new StringBuffer());
    }

    public XElement(String objectName, Attributes atts) {
        if (objectName == null) {
            throw new NullPointerException();
        }
        if (atts == null) {
            throw new NullPointerException();
        }
        this.name = objectName;
        this.contents.addElement(new StringBuffer());
        for (int i = 0; i < atts.getLength(); ++i) {
            this.metadata.put(atts.getQName(i), atts.getValue(i));
        }
    }

    public void setAttribute(String key, String value) {
        this.metadata.put(key, value);
    }

    public void setName(String newName) {
        this.name = newName;
    }

    public void setValue(String value) throws XElementException {
        if (!this.isField()) {
            throw new XElementException("" + this.getName() + " is not an attribute object");
        }
        this.contents.setElementAt(new StringBuffer(value), 0);
    }

    public void setField(String key, String value) throws XElementException {
        this.getElement(key).setValue(value);
    }

    public String getAttribute(String key) {
        String t = (String)this.metadata.get(key);
        if (t == null) {
            return "";
        }
        return t;
    }

    public String getName() {
        return this.name;
    }

    public XElement getParent() {
        return this.parent;
    }

    public String getText() {
        return this.contents.elementAt(0).toString().trim();
    }

    public String getValue() throws XElementException {
        if (!this.isField()) {
            throw new XElementException("" + this.getName() + " is not an attribute object");
        }
        return this.contents.elementAt(0).toString();
    }

    public XElement getElement(String relativeName) throws XElementException {
        if (relativeName == null) {
            throw new NullPointerException();
        }
        String[] names = new String[]{null, relativeName};
        String[] split = XElement.splitFront(relativeName, "/");
        if (split != null) {
            if (split[0].length() == 0) {
                if (this.parent == null) {
                    split[0] = null;
                } else {
                    return this.parent.getElement(relativeName);
                }
            }
            if (split[1].length() == 0) {
                if (split[0].equals(null)) {
                    return this;
                }
                throw new XElementException("Invalid name (trailing '/') : " + relativeName);
            }
            names = split;
        }
        if (names[0] == null) {
            for (int i = 1; i < this.contents.size(); ++i) {
                XElement o = (XElement)this.contents.elementAt(i);
                if (!names[1].equals(o.getName())) continue;
                return o;
            }
        } else {
            if (names[0].equals(".")) {
                return this.getElement(names[1]);
            }
            if (names[0].equals("..")) {
                if (this.parent != null) {
                    return this.parent.getElement(names[1]);
                }
                throw new XElementException("Invalid name (" + this.getName() + " has no parent) : " + relativeName);
            }
            for (int i = 1; i < this.contents.size(); ++i) {
                XElement o = (XElement)this.contents.elementAt(i);
                if (!names[0].equals(o.getName())) continue;
                return o.getElement(names[1]);
            }
        }
        throw new XElementException("Invalid name (" + this.getName() + " does not contain the name) : " + relativeName);
    }

    public String getField(String objectName) throws XElementException {
        return this.getElement(objectName).getValue();
    }

    public boolean isField() {
        return this.contents.size() == 1;
    }

    public Enumeration getElementsNamed(String relativeName) {
        Vector t = new Vector();
        this.addElementsToVector(t, relativeName);
        return t.elements();
    }

    public void add(String data) {
        ((StringBuffer)this.contents.elementAt(0)).append(data);
    }

    public String toString() {
        return this.toString(0, true);
    }

    public void addElement(XElement subObject) {
        this.contents.addElement(subObject);
        subObject.parent = this;
    }

    public void addField(String key, String value) {
        XElement subObject = new XElement(key);
        subObject.add(value);
        this.addElement(subObject);
    }

    public boolean containsElement(String objectName) {
        try {
            this.getElement(objectName);
            return true;
        }
        catch (XElementException e) {
            return false;
        }
    }

    public boolean containsField(String objectName) {
        try {
            XElement obj = this.getElement(objectName);
            return obj.isField();
        }
        catch (XElementException e) {
            return false;
        }
    }

    public String toString(int nestingLevel, boolean indent) {
        try {
            StringBuffer indentation = new StringBuffer();
            StringBuffer rc = new StringBuffer();
            if (indent) {
                for (int i = 0; i < nestingLevel; ++i) {
                    indentation.append('\t');
                }
            }
            rc.append(indentation.toString());
            rc.append("<");
            rc.append(this.getName());
            Enumeration enumeration = this.metadata.keys();
            while (enumeration.hasMoreElements()) {
                String key = (String)enumeration.nextElement();
                String value = (String)this.metadata.get(key);
                rc.append(' ');
                rc.append(key);
                rc.append("=\"");
                rc.append(XElement.metaValueEncode(value));
                rc.append('\"');
            }
            if (this.isField()) {
                if (this.getValue().length() == 0) {
                    rc.append("/>");
                    rc.append(nl);
                } else {
                    rc.append('>');
                    rc.append(XElement.valueEncode(this.getValue()));
                    rc.append("</");
                    rc.append(this.getName());
                    rc.append('>');
                    rc.append(nl);
                }
            } else {
                rc.append('>');
                rc.append(nl);
                String text = this.getText();
                if (text.length() > 0) {
                    rc.append(indentation.toString() + "\t");
                    rc.append(this.getText());
                    rc.append(nl);
                }
                for (int i = 1; i < this.contents.size(); ++i) {
                    Object o = this.contents.elementAt(i);
                    rc.append(((XElement)o).toString(nestingLevel + 1, indent));
                }
                rc.append(indentation.toString());
                rc.append("</");
                rc.append(this.getName());
                rc.append('>');
                rc.append(nl);
            }
            return rc.toString();
        }
        catch (XElementException e) {
            e.printStackTrace();
            System.exit(1);
            return "";
        }
    }

    public String toXML(boolean indent) {
        return "<?xml version=\"1.0\" encoding=\"UTF-8\"?>" + nl + this.toString(0, indent);
    }

    public void removeFromParent() throws XElementException {
        if (this.parent == null) {
            throw new XElementException("" + this.getName() + " does not have a parent");
        }
        this.parent.contents.remove(this);
        this.parent = null;
    }

    public Enumeration elements() {
        return this.getElementsNamed("*");
    }

    private void addElementsToVector(Vector t, String relativeName) {
        String[] names = new String[]{null, relativeName};
        String[] split = XElement.splitFront(relativeName, "/");
        if (split != null) {
            if (split[0].length() == 0) {
                if (this.parent == null) {
                    split[0] = null;
                } else {
                    this.parent.addElementsToVector(t, relativeName);
                    return;
                }
            }
            if (split[1].length() == 0) {
                return;
            }
            names = split;
        }
        if (names[0] == null) {
            if (names[1].equals("*")) {
                for (int i = 1; i < this.contents.size(); ++i) {
                    t.addElement(this.contents.elementAt(i));
                }
            } else {
                for (int i = 1; i < this.contents.size(); ++i) {
                    XElement o = (XElement)this.contents.elementAt(i);
                    if (!names[1].equals(o.getName())) continue;
                    t.addElement(o);
                }
            }
        } else {
            if (names[0].equals(".")) {
                this.addElementsToVector(t, names[1]);
                return;
            }
            if (names[0].equals("..")) {
                if (this.parent != null) {
                    this.parent.addElementsToVector(t, names[1]);
                }
                return;
            }
            for (int i = 1; i < this.contents.size(); ++i) {
                XElement o = (XElement)this.contents.elementAt(i);
                if (!names[0].equals(o.getName())) continue;
                o.addElementsToVector(t, names[1]);
            }
        }
    }

    public static XElement createFrom(InputStream is) throws XElementException, IOException {
        class MyRecordConsumer
        implements XElementConsumer {
            XElement root = null;

            MyRecordConsumer() {
            }

            public void documentEndEvent() {
            }

            public void documentStartEvent() {
            }

            public void recordReadEvent(XElement o) {
                this.root = o;
            }
        }
        MyRecordConsumer consumer = new MyRecordConsumer();
        XElementProducer producer = new XElementProducer(consumer);
        try {
            producer.parse(is);
            if (consumer.root == null) {
                throw new XElementException("No root element");
            }
            return consumer.root;
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new XElementException("Parse Error: " + e);
        }
    }

    public static XElement createFrom(URL url) throws XElementException, IOException {
        class MyRecordConsumer
        implements XElementConsumer {
            XElement root = null;

            MyRecordConsumer() {
            }

            public void documentEndEvent() {
            }

            public void documentStartEvent() {
            }

            public void recordReadEvent(XElement o) {
                this.root = o;
            }
        }
        MyRecordConsumer consumer = new MyRecordConsumer();
        XElementProducer producer = new XElementProducer(consumer);
        try {
            producer.parse(url);
            if (consumer.root == null) {
                throw new XElementException("No root element");
            }
            return consumer.root;
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new XElementException("Parse Error: " + e);
        }
    }

    private static String findAndReplace(String value, String searchStr, String replaceStr) {
        StringBuffer buffer = new StringBuffer(value.length());
        while (value.length() > 0) {
            int pos = value.indexOf(searchStr);
            if (pos != -1) {
                buffer.append(value.substring(0, pos));
                buffer.append(replaceStr);
                if (pos + searchStr.length() < value.length()) {
                    value = value.substring(pos + searchStr.length());
                    continue;
                }
                value = "";
                continue;
            }
            buffer.append(value);
            value = "";
        }
        return buffer.toString();
    }

    private static String metaValueEncode(String value) {
        value = XElement.findAndReplace(value, "&", "&amp;");
        value = XElement.findAndReplace(value, "\"", "&quot;");
        value = XElement.findAndReplace(value, "'", "&apos;");
        return XElement.utf8Encode(value);
    }

    private static String utf8Encode(String value) {
        try {
            char[] buff = new char[value.length()];
            value.getChars(0, buff.length, buff, 0);
            CharToByteUTF8 conv = new CharToByteUTF8();
            byte[] b = conv.convertAll(buff);
            return new String(b);
        }
        catch (MalformedInputException e) {
            return null;
        }
    }

    private static String valueEncode(String value) {
        value = XElement.findAndReplace(value, "&", "&amp;");
        value = XElement.findAndReplace(value, "<", "&lt;");
        value = XElement.findAndReplace(value, ">", "&gt;");
        return XElement.utf8Encode(value);
    }

    private static String[] splitFront(String string, String splitMarker) {
        if (string == null || splitMarker == null) {
            throw new NullPointerException();
        }
        int pos = string.indexOf(splitMarker);
        if (pos == -1) {
            return null;
        }
        int l = splitMarker.length();
        String front = string.substring(0, pos);
        String back = pos + l >= string.length() ? "" : string.substring(pos + l);
        String[] rc = new String[]{front, back};
        return rc;
    }

    public String getOptionalField(String field) throws XElementException {
        if (!this.containsField(field)) {
            return null;
        }
        return this.getField(field);
    }

    public void setOptionalField(String field, String value) throws XElementException {
        if (value == null) {
            if (this.containsField(field)) {
                this.getElement(field).removeFromParent();
            }
            return;
        }
        if (this.containsField(field)) {
            this.setField(field, value);
        } else {
            this.addField(field, value);
        }
    }
}

