/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.snmp.util;

import com.clustercontrol.snmp.bean.MonitorSnmpInfo;
import com.clustercontrol.snmp.ejb.entity.MonitorSnmpInfoLocal;
import com.clustercontrol.snmp.ejb.entity.MonitorSnmpInfoPK;
import com.clustercontrol.snmp.ejb.entity.MonitorSnmpInfoUtil;
import com.clustercontrol.snmp.ejb.entity.MonitorSnmpValueLocal;
import com.clustercontrol.snmp.ejb.entity.MonitorSnmpValueUtil;
import com.clustercontrol.util.apllog.AplLogger;
import java.util.Collection;
import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ControlSnmpInfo {
    protected static Log m_log = LogFactory.getLog(ControlSnmpInfo.class);
    protected String m_monitorTypeId;
    protected String m_monitorId;

    public ControlSnmpInfo(String id, String typeId) {
        this.m_monitorId = id;
        this.m_monitorTypeId = typeId;
    }

    public MonitorSnmpInfo get() throws FinderException, NamingException {
        MonitorSnmpInfoPK pk = new MonitorSnmpInfoPK(this.m_monitorId, this.m_monitorTypeId);
        MonitorSnmpInfoLocal snmpLocal = MonitorSnmpInfoUtil.getLocalHome().findByPrimaryKey(pk);
        MonitorSnmpInfo snmp = new MonitorSnmpInfo();
        snmp.setMonitorTypeId(this.m_monitorTypeId);
        snmp.setMonitorId(this.m_monitorId);
        snmp.setCommunityName(snmpLocal.getCommunityName());
        snmp.setSnmpOid(snmpLocal.getSnmpOid());
        snmp.setConvertFlg(snmpLocal.getConvertFlg());
        return snmp;
    }

    public boolean add(MonitorSnmpInfo snmp) throws CreateException, NamingException {
        MonitorSnmpInfoUtil.getLocalHome().create(this.m_monitorTypeId, this.m_monitorId, snmp.getCommunityName(), snmp.getSnmpOid(), snmp.getConvertFlg());
        return true;
    }

    public boolean modify(MonitorSnmpInfo snmp, boolean deleteValueFlg) throws CreateException, FinderException, NamingException {
        MonitorSnmpInfoPK pk = new MonitorSnmpInfoPK(this.m_monitorId, this.m_monitorTypeId);
        MonitorSnmpInfoLocal snmpLocal = MonitorSnmpInfoUtil.getLocalHome().findByPrimaryKey(pk);
        String prevSnmpOid = snmpLocal.getSnmpOid();
        snmpLocal.setCommunityName(snmp.getCommunityName());
        snmpLocal.setSnmpOid(snmp.getSnmpOid());
        snmpLocal.setConvertFlg(snmp.getConvertFlg());
        if (deleteValueFlg || !prevSnmpOid.equals(snmp.getSnmpOid())) {
            try {
                Collection ct = MonitorSnmpValueUtil.getLocalHome().findByMonitorId(this.m_monitorId);
                if (ct != null && ct.size() > 0) {
                    Object[] infoArray = ct.toArray();
                    for (int j = 0; j < infoArray.length; ++j) {
                        MonitorSnmpValueLocal value = (MonitorSnmpValueLocal)infoArray[j];
                        if (value == null) continue;
                        value.remove();
                    }
                }
            }
            catch (RemoveException e) {
                AplLogger apllog = new AplLogger("SNMP", "snmp");
                Object[] args = new String[]{this.m_monitorId};
                apllog.put("SYS", "001", args);
                m_log.debug((Object)("modifyCheckInfo():" + e.getMessage()));
                return false;
            }
        }
        return true;
    }

    public boolean delete() throws FinderException, RemoveException, NamingException {
        MonitorSnmpInfoPK pk = new MonitorSnmpInfoPK(this.m_monitorId, this.m_monitorTypeId);
        MonitorSnmpInfoLocal snmpLocal = MonitorSnmpInfoUtil.getLocalHome().findByPrimaryKey(pk);
        snmpLocal.remove();
        try {
            Collection ct = MonitorSnmpValueUtil.getLocalHome().findByMonitorId(this.m_monitorId);
            if (ct != null && ct.size() > 0) {
                Object[] infoArray = ct.toArray();
                for (int j = 0; j < infoArray.length; ++j) {
                    MonitorSnmpValueLocal value = (MonitorSnmpValueLocal)infoArray[j];
                    if (value == null) continue;
                    value.remove();
                }
            }
        }
        catch (Exception e) {
            AplLogger apllog = new AplLogger("SNMP", "snmp");
            Object[] args = new String[]{this.m_monitorId};
            apllog.put("SYS", "001", args);
            m_log.debug((Object)("deleteCheckInfo():" + e.getMessage()));
            return false;
        }
        return true;
    }
}

