/*
 * Decompiled with CFR 0.152.
 */
package org.postgresforest.core.types;

import java.math.BigDecimal;
import org.postgresforest.core.types.PGBigDecimal;
import org.postgresforest.core.types.PGBoolean;
import org.postgresforest.core.types.PGDouble;
import org.postgresforest.core.types.PGFloat;
import org.postgresforest.core.types.PGString;
import org.postgresforest.core.types.PGType;
import org.postgresforest.core.types.PGUnknown;
import org.postgresforest.util.GT;
import org.postgresforest.util.PSQLException;
import org.postgresforest.util.PSQLState;

public class PGShort
implements PGType {
    Short val;

    protected PGShort(Short x) {
        this.val = x;
    }

    public static PGType castToServerType(Short val, int targetType) throws PSQLException {
        try {
            switch (targetType) {
                case -7: {
                    return new PGBoolean(val == 0 ? Boolean.FALSE : Boolean.TRUE);
                }
                case -6: 
                case 5: {
                    return new PGShort(val);
                }
                case 7: {
                    return new PGFloat(new Float(val.floatValue()));
                }
                case 6: 
                case 8: {
                    return new PGDouble(new Double(val.doubleValue()));
                }
                case -1: 
                case 12: {
                    return new PGString(val.toString());
                }
                case 2: 
                case 3: {
                    return new PGBigDecimal(new BigDecimal(val.toString()));
                }
            }
            return new PGUnknown(val);
        }
        catch (Exception ex) {
            throw new PSQLException(GT.tr("Cannot convert an instance of {0} to type {1}", new Object[]{val.getClass().getName(), "Types.OTHER"}), PSQLState.INVALID_PARAMETER_TYPE, (Throwable)ex);
        }
    }

    public String toString() {
        return this.val.toString();
    }
}

