/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.resolver;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.osgi.internal.resolver.BundleDescriptionImpl;
import org.eclipse.osgi.internal.resolver.ComputeNodeOrder;
import org.eclipse.osgi.internal.resolver.StateImpl;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.BundleSpecification;
import org.eclipse.osgi.service.resolver.ExportPackageDescription;
import org.eclipse.osgi.service.resolver.HostSpecification;
import org.eclipse.osgi.service.resolver.ImportPackageSpecification;
import org.eclipse.osgi.service.resolver.State;
import org.eclipse.osgi.service.resolver.StateHelper;
import org.eclipse.osgi.service.resolver.VersionConstraint;

public class StateHelperImpl
implements StateHelper {
    private static StateHelper instance = new StateHelperImpl();

    public BundleDescription[] getDependentBundles(BundleDescription[] roots) {
        if (roots == null || roots.length == 0) {
            return new BundleDescription[0];
        }
        HashSet reachable = new HashSet(roots.length);
        int i = 0;
        while (i < roots.length) {
            if (roots[i].isResolved()) {
                this.addDependentBundles(roots[i], reachable);
            }
            ++i;
        }
        return reachable.toArray(new BundleDescription[reachable.size()]);
    }

    private void addDependentBundles(BundleDescription root, Set reachable) {
        if (reachable.contains(root)) {
            return;
        }
        reachable.add(root);
        BundleDescription[] dependents = root.getDependents();
        int i = 0;
        while (i < dependents.length) {
            this.addDependentBundles(dependents[i], reachable);
            ++i;
        }
    }

    public VersionConstraint[] getUnsatisfiedConstraints(BundleDescription bundle) {
        State containingState = bundle.getContainingState();
        if (containingState == null) {
            throw new IllegalStateException("Does not belong to a state");
        }
        ArrayList<VersionConstraint> unsatisfied = new ArrayList<VersionConstraint>();
        HostSpecification host = bundle.getHost();
        if (host != null && !host.isResolved() && !this.isResolvable(host)) {
            unsatisfied.add(host);
        }
        BundleSpecification[] requiredBundles = bundle.getRequiredBundles();
        int i = 0;
        while (i < requiredBundles.length) {
            if (!requiredBundles[i].isResolved() && !this.isResolvable(requiredBundles[i])) {
                unsatisfied.add(requiredBundles[i]);
            }
            ++i;
        }
        ImportPackageSpecification[] packages = bundle.getImportPackages();
        int i2 = 0;
        while (i2 < packages.length) {
            if (!packages[i2].isResolved() && !this.isResolvable(packages[i2])) {
                unsatisfied.add(packages[i2]);
            }
            ++i2;
        }
        return unsatisfied.toArray(new VersionConstraint[unsatisfied.size()]);
    }

    public boolean isResolvable(ImportPackageSpecification constraint) {
        ExportPackageDescription[] exports = constraint.getBundle().getContainingState().getExportedPackages();
        int i = 0;
        while (i < exports.length) {
            if (constraint.isSatisfiedBy(exports[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean isResolvable(BundleSpecification specification) {
        return this.isBundleConstraintResolvable(specification);
    }

    public boolean isResolvable(HostSpecification specification) {
        return this.isBundleConstraintResolvable(specification);
    }

    private boolean isBundleConstraintResolvable(VersionConstraint constraint) {
        BundleDescription[] availableBundles = constraint.getBundle().getContainingState().getBundles(constraint.getName());
        int i = 0;
        while (i < availableBundles.length) {
            if (availableBundles[i].isResolved() && constraint.isSatisfiedBy(availableBundles[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public Object[][] sortBundles(BundleDescription[] toSort) {
        ArrayList references = new ArrayList(toSort.length);
        int i = 0;
        while (i < toSort.length) {
            if (toSort[i].isResolved()) {
                this.buildReferences(toSort[i], references);
            }
            ++i;
        }
        return ComputeNodeOrder.computeNodeOrder(toSort, (Object[][])references.toArray((T[])new Object[references.size()][]));
    }

    private void buildReferences(BundleDescription description, List references) {
        HostSpecification host = description.getHost();
        if (host != null) {
            if (host.getHosts() != null) {
                BundleDescription[] hosts = host.getHosts();
                int i = 0;
                while (i < hosts.length) {
                    if (hosts[i] != description) {
                        references.add(new Object[]{description, hosts[i]});
                    }
                    ++i;
                }
            }
        } else {
            this.buildReferences(description, ((BundleDescriptionImpl)description).getBundleDependencies(), references);
        }
    }

    private void buildReferences(BundleDescription description, List dependencies, List references) {
        Iterator iter = dependencies.iterator();
        while (iter.hasNext()) {
            this.addReference(description, (BundleDescription)iter.next(), references);
        }
    }

    private void addReference(BundleDescription description, BundleDescription reference, List references) {
        if (description == reference || reference == null) {
            return;
        }
        references.add(new Object[]{description, reference});
    }

    public ExportPackageDescription[] getVisiblePackages(BundleDescription bundle) {
        StateImpl state = (StateImpl)bundle.getContainingState();
        boolean strict = false;
        if (state != null) {
            strict = state.inStrictMode();
        }
        ArrayList<ExportPackageDescription> packageList = new ArrayList<ExportPackageDescription>();
        ArrayList<String> importList = new ArrayList<String>();
        ExportPackageDescription[] resolvedImports = bundle.getResolvedImports();
        int i = 0;
        while (i < resolvedImports.length) {
            packageList.add(resolvedImports[i]);
            importList.add(resolvedImports[i].getName());
            ++i;
        }
        BundleDescription[] requiredBundles = bundle.getResolvedRequires();
        ArrayList visited = new ArrayList(requiredBundles.length);
        int i2 = 0;
        while (i2 < requiredBundles.length) {
            this.getPackages(requiredBundles[i2], bundle.getSymbolicName(), importList, packageList, visited, strict);
            ++i2;
        }
        return packageList.toArray(new ExportPackageDescription[packageList.size()]);
    }

    private void getPackages(BundleDescription requiredBundle, String symbolicName, List importList, List packageList, List visited, boolean strict) {
        if (visited.contains(requiredBundle)) {
            return;
        }
        visited.add(requiredBundle);
        ExportPackageDescription[] exports = requiredBundle.getSelectedExports();
        int i = 0;
        while (i < exports.length) {
            if (!this.isSystemExport(exports[i]) && this.isFriend(symbolicName, exports[i], strict) && !importList.contains(exports[i].getName())) {
                packageList.add(exports[i]);
            }
            ++i;
        }
        BundleSpecification[] requiredBundles = requiredBundle.getRequiredBundles();
        int i2 = 0;
        while (i2 < requiredBundles.length) {
            if (requiredBundles[i2].isExported() && requiredBundles[i2].getSupplier() != null) {
                this.getPackages((BundleDescription)requiredBundles[i2].getSupplier(), symbolicName, importList, packageList, visited, strict);
            }
            ++i2;
        }
    }

    private boolean isSystemExport(ExportPackageDescription export) {
        StateImpl state = (StateImpl)export.getExporter().getContainingState();
        if (state == null) {
            return false;
        }
        ExportPackageDescription[] systemExports = state.getSystemPackages();
        int i = 0;
        while (i < systemExports.length) {
            if (systemExports[i] == export) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean isFriend(String consumerBSN, ExportPackageDescription export, boolean strict) {
        if (!strict) {
            return true;
        }
        String[] friends = (String[])export.getDirective("x-friends");
        if (friends == null) {
            return true;
        }
        int i = 0;
        while (i < friends.length) {
            if (friends[i].equals(consumerBSN)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public int getAccessCode(BundleDescription bundle, ExportPackageDescription export) {
        if (((Boolean)export.getDirective("x-internal")).booleanValue()) {
            return 2;
        }
        if (!this.isFriend(bundle.getSymbolicName(), export, true)) {
            return 2;
        }
        return 1;
    }

    public static StateHelper getInstance() {
        return instance;
    }
}

