/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.rtf.graphic;

import com.lowagie.text.DocumentException;
import com.lowagie.text.Image;
import com.lowagie.text.pdf.codec.wmf.MetaDo;
import com.lowagie.text.rtf.RtfBasicElement;
import com.lowagie.text.rtf.RtfElement;
import com.lowagie.text.rtf.document.RtfDocument;
import com.lowagie.text.rtf.text.RtfParagraph;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class RtfImage
extends RtfElement {
    private static final byte[] PICTURE_GROUP = "\\*\\shppict".getBytes();
    private static final byte[] PICTURE = "\\pict".getBytes();
    private static final byte[] PICTURE_JPEG = "\\jpegblip".getBytes();
    private static final byte[] PICTURE_PNG = "\\pngblip".getBytes();
    private static final byte[] PICTURE_BMP = "\\dibitmap0".getBytes();
    private static final byte[] PICTURE_WMF = "\\wmetafile8".getBytes();
    private static final byte[] PICTURE_WIDTH = "\\picw".getBytes();
    private static final byte[] PICTURE_HEIGHT = "\\pich".getBytes();
    private static final byte[] PICTURE_SCALE_X = "\\picscalex".getBytes();
    private static final byte[] PICTURE_SCALE_Y = "\\picscaley".getBytes();
    private int imageType = 0;
    private byte[] image = new byte[0];
    private int alignment = 0;
    private float width = 0.0f;
    private float height = 0.0f;
    private float plainWidth = 0.0f;
    private float plainHeight = 0.0f;

    public RtfImage(RtfDocument doc, Image image) throws DocumentException {
        super(doc);
        this.imageType = image.getOriginalType();
        if (this.imageType != 1 && this.imageType != 4 && this.imageType != 2 && this.imageType != 6) {
            throw new DocumentException("Only BMP, PNG, WMF and JPEG images are supported by the RTF Writer");
        }
        this.alignment = image.alignment();
        this.width = image.width();
        this.height = image.height();
        this.plainWidth = image.plainWidth();
        this.plainHeight = image.plainHeight();
        this.image = this.getImage(image);
    }

    private byte[] getImage(Image image) throws DocumentException {
        ByteArrayOutputStream imageTemp = new ByteArrayOutputStream();
        try {
            InputStream imageIn;
            if (this.imageType == 4) {
                imageIn = new ByteArrayInputStream(MetaDo.wrapBMP(image));
            } else {
                imageIn = image.getOriginalData() == null ? image.url().openStream() : new ByteArrayInputStream(image.getOriginalData());
                if (this.imageType == 6) {
                    long skipLength = 22L;
                    while (skipLength > 0L) {
                        skipLength -= imageIn.skip(skipLength);
                    }
                }
            }
            int buffer = 0;
            int count = 0;
            while ((buffer = imageIn.read()) != -1) {
                String helperStr = Integer.toHexString(buffer);
                if (helperStr.length() < 2) {
                    helperStr = "0" + helperStr;
                }
                imageTemp.write(helperStr.getBytes());
                if (++count != 64) continue;
                imageTemp.write(10);
                count = 0;
            }
        }
        catch (IOException ioe) {
            throw new DocumentException(ioe.getMessage());
        }
        return imageTemp.toByteArray();
    }

    public byte[] write() {
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        try {
            switch (this.alignment) {
                case 0: {
                    result.write(RtfParagraph.ALIGN_LEFT);
                    break;
                }
                case 2: {
                    result.write(RtfParagraph.ALIGN_RIGHT);
                    break;
                }
                case 1: {
                    result.write(RtfParagraph.ALIGN_CENTER);
                    break;
                }
                case 3: {
                    result.write(RtfParagraph.ALIGN_JUSTIFY);
                }
            }
            result.write(RtfBasicElement.OPEN_GROUP);
            result.write(PICTURE_GROUP);
            result.write(RtfBasicElement.OPEN_GROUP);
            result.write(PICTURE);
            switch (this.imageType) {
                case 1: {
                    result.write(PICTURE_JPEG);
                    break;
                }
                case 2: {
                    result.write(PICTURE_PNG);
                    break;
                }
                case 4: 
                case 6: {
                    result.write(PICTURE_WMF);
                }
            }
            result.write(PICTURE_WIDTH);
            result.write(this.intToByteArray((int)((double)this.plainWidth * 20.0)));
            result.write(PICTURE_HEIGHT);
            result.write(this.intToByteArray((int)((double)this.plainHeight * 20.0)));
            if (this.width > 0.0f) {
                result.write(PICTURE_SCALE_X);
                result.write(this.intToByteArray((int)(100.0f / this.width * this.plainWidth)));
            }
            if (this.height > 0.0f) {
                result.write(PICTURE_SCALE_Y);
                result.write(this.intToByteArray((int)(100.0f / this.height * this.plainHeight)));
            }
            result.write(RtfBasicElement.DELIMITER);
            result.write(10);
            result.write(this.image);
            result.write(RtfBasicElement.CLOSE_GROUP);
            result.write(RtfBasicElement.CLOSE_GROUP);
            result.write(10);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return result.toByteArray();
    }
}

