/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.performanceMGR.dao;

import com.clustercontrol.commons.util.ConnectionManager;
import com.clustercontrol.performanceMGR.bean.CollectedDataInfo;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.ejb.EJBException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CalculatedDataDAO {
    protected static Log m_log = LogFactory.getLog(CalculatedDataDAO.class);

    public List select(String collectorID, String itemCode, int deviceIndex, String facilityID, Date startDate, Date stopDate) throws EJBException {
        m_log.debug((Object)("select() start :" + collectorID + " " + itemCode + " " + deviceIndex + " " + facilityID));
        ArrayList<CollectedDataInfo> ret = new ArrayList<CollectedDataInfo>();
        Connection conn = null;
        Statement stmt = null;
        ResultSet res = null;
        try {
            conn = ConnectionManager.getConnectionManager().getConnection();
            String sql = "SELECT * FROM CALCULATED_DATA WHERE COLLECTORID=? AND ITEM_CODE=? AND DEVICE_INDEX=? AND FACILITYID=? AND DATE_TIME BETWEEN ? AND ?ORDER BY DATE_TIME";
            stmt = conn.prepareStatement(sql);
            Timestamp start = new Timestamp(startDate.getTime());
            Timestamp stop = new Timestamp(stopDate.getTime());
            stmt.setString(1, collectorID);
            stmt.setString(2, itemCode);
            stmt.setInt(3, deviceIndex);
            stmt.setString(4, facilityID);
            stmt.setTimestamp(5, start);
            stmt.setTimestamp(6, stop);
            res = stmt.executeQuery();
            while (res.next()) {
                CollectedDataInfo data = new CollectedDataInfo(facilityID, itemCode, deviceIndex);
                data.setDate(new Date(res.getTimestamp("DATE_TIME").getTime()));
                if (res.getObject("VALUE") != null) {
                    data.setValue(res.getDouble("VALUE"));
                } else {
                    data.setValue(Double.NaN);
                }
                ret.add(data);
            }
        }
        catch (SQLException e) {
            m_log.error((Object)("select() error :" + facilityID + " EJBException "), (Throwable)e);
            throw new EJBException(e.getMessage());
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e1) {
                m_log.error((Object)("select() error :" + facilityID + " EJBException "));
                throw new EJBException(e1.getMessage());
            }
        }
        m_log.debug((Object)("select() end   :" + collectorID + " " + itemCode + " " + deviceIndex + " " + facilityID));
        return ret;
    }

    public void delete(String collectorID) throws EJBException {
        m_log.debug((Object)("delete() start :" + collectorID));
        Connection conn = null;
        Statement stmt = null;
        try {
            conn = ConnectionManager.getConnectionManager().getConnection();
            String sql = "DELETE FROM CALCULATED_DATA WHERE COLLECTORID = ? ";
            stmt = conn.prepareStatement(sql);
            stmt.setString(1, collectorID);
            stmt.executeUpdate();
        }
        catch (SQLException e) {
            m_log.error((Object)("delete() error :" + collectorID + " EJBException "));
            throw new EJBException(e.getMessage());
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e1) {
                m_log.error((Object)("delete() error :" + collectorID + " EJBException "));
                throw new EJBException(e1.getMessage());
            }
            m_log.debug((Object)("delete() end   :" + collectorID));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void insert(String collectorID, CollectedDataInfo data) throws EJBException {
        m_log.debug((Object)("insert() start : " + collectorID + " " + data.getItemCode() + " " + data.getDeviceIndex() + " " + data.getFacilityID()));
        Connection conn = null;
        PreparedStatement stmt = null;
        Timestamp time = new Timestamp(data.getDate().getTime());
        try {
            try {
                conn = ConnectionManager.getConnectionManager().getConnection();
                String sql = "INSERT INTO CALCULATED_DATA (collectorId, item_code, device_index, date_time, facilityid, value) values (?,?,?,?,?,?);";
                stmt = conn.prepareStatement(sql);
                stmt.setString(1, collectorID);
                stmt.setString(2, data.getItemCode());
                stmt.setInt(3, data.getDeviceIndex());
                stmt.setTimestamp(4, time);
                stmt.setString(5, data.getFacilityID());
                if (Double.isNaN(data.getValue())) {
                    stmt.setNull(6, 8);
                } else {
                    stmt.setDouble(6, data.getValue());
                }
                int row = stmt.executeUpdate();
                if (row != 1) {
                    String msg = "result row is not 1";
                    throw new SQLException(msg);
                }
                Object var10_10 = null;
            }
            catch (SQLException e) {
                m_log.error((Object)("insert() error :" + collectorID + " EJBException "));
                throw new EJBException(e.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e1) {
                m_log.error((Object)("insert() error :" + collectorID + " EJBException "));
                throw new EJBException(e1.getMessage());
            }
            m_log.debug((Object)("insert() end   : " + collectorID + " " + data.getItemCode() + " " + data.getDeviceIndex() + " " + data.getFacilityID()));
            throw throwable;
        }
        try {}
        catch (SQLException e1) {
            m_log.error((Object)("insert() error :" + collectorID + " EJBException "));
            throw new EJBException(e1.getMessage());
        }
        if (stmt != null) {
            stmt.close();
        }
        if (conn != null) {
            conn.close();
        }
        m_log.debug((Object)("insert() end   : " + collectorID + " " + data.getItemCode() + " " + data.getDeviceIndex() + " " + data.getFacilityID()));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void deleteOverPresave(String collectorID, Date startDate) throws EJBException {
        m_log.debug((Object)("deleteOrverPresave() start :" + collectorID + " " + startDate.toString()));
        Connection conn = null;
        PreparedStatement stmt = null;
        Timestamp time = new Timestamp(startDate.getTime());
        try {
            try {
                conn = ConnectionManager.getConnectionManager().getConnection();
                String sql = "DELETE FROM CALCULATED_DATA WHERE COLLECTORID = ? AND DATE_TIME < ?";
                stmt = conn.prepareStatement(sql);
                stmt.setString(1, collectorID);
                stmt.setTimestamp(2, time);
                stmt.executeUpdate();
            }
            catch (SQLException e) {
                m_log.debug((Object)("deleteOrverPresave() error :" + collectorID + " " + startDate.toString() + "  EJBException "));
                throw new EJBException(e.getMessage());
            }
            Object var8_8 = null;
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e1) {
                m_log.debug((Object)("deleteOrverPresave() error :" + collectorID + " " + startDate.toString() + "  EJBException "));
                throw new EJBException(e1.getMessage());
            }
            m_log.debug((Object)("deleteOrverPresave() end :" + collectorID + " " + startDate.toString() + "  EJBException "));
            throw throwable;
        }
        try {}
        catch (SQLException e1) {
            m_log.debug((Object)("deleteOrverPresave() error :" + collectorID + " " + startDate.toString() + "  EJBException "));
            throw new EJBException(e1.getMessage());
        }
        if (stmt != null) {
            stmt.close();
        }
        if (conn != null) {
            conn.close();
        }
        m_log.debug((Object)("deleteOrverPresave() end :" + collectorID + " " + startDate.toString() + "  EJBException "));
    }

    public int recountFromDB(String collectorID) throws EJBException {
        m_log.debug((Object)("recountFromDB() start :" + collectorID));
        Connection conn = null;
        Statement stmt = null;
        ResultSet res = null;
        int ret = 0;
        try {
            conn = ConnectionManager.getConnectionManager().getConnection();
            String sql = "SELECT COUNT(*) AS COLLECT_COUNT FROM calculated_data WHERE collectorid =? group by item_code , facilityid limit 1";
            stmt = conn.prepareStatement(sql);
            stmt.setString(1, collectorID);
            res = stmt.executeQuery();
            if (res.next()) {
                ret = res.getInt("COLLECT_COUNT");
            }
        }
        catch (SQLException e) {
            m_log.error((Object)("recountFromDB() error :" + collectorID + " EJBException "), (Throwable)e);
            throw new EJBException(e.getMessage());
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e1) {
                m_log.error((Object)("recountFromDB() error :" + collectorID + " EJBException "));
                throw new EJBException(e1.getMessage());
            }
        }
        m_log.debug((Object)("recountFromDB() end   :" + collectorID + " "));
        return ret;
    }
}

