/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.monitor.run.composite;

import com.clustercontrol.bean.PriorityConstant;
import com.clustercontrol.bean.YesNoConstant;
import com.clustercontrol.dialog.ValidateResult;
import com.clustercontrol.jobmanagement.common.composite.JobIdSelectionListener;
import com.clustercontrol.monitor.run.bean.MonitorStringValueInfo;
import com.clustercontrol.util.Messages;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class StringRunJobComposite
extends Composite {
    public static final int WIDTH_JOB_ID = 4;
    public static final int WIDTH_REF_BTN = 2;
    public static final int WIDTH_INHIBITION_FLG = 3;
    public static final int WIDTH_FAILURE_PRIORITY = 2;
    private Text m_textJobId = null;
    private Button m_buttonRefer = null;
    private Button m_checkInhibitionFlg = null;
    private Combo m_comboFailurePriority = null;

    public StringRunJobComposite(Composite parent, int style) {
        super(parent, style);
        this.initialize();
    }

    private void initialize() {
        Label label = null;
        GridData gridData = null;
        GridLayout layout = new GridLayout(1, true);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 15;
        this.setLayout((Layout)layout);
        label = new Label((Composite)this, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 6;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label.setText(Messages.getString("job.id"));
        label = new Label((Composite)this, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label = new Label((Composite)this, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label.setText(Messages.getString("couple.with.notify.inhibition"));
        label = new Label((Composite)this, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label = new Label((Composite)this, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label.setText(Messages.getString("failure.call.value"));
        label = new Label((Composite)this, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        this.m_textJobId = this.getTextJobId(this, 4);
        this.m_buttonRefer = this.getButtonRefer(this, 2);
        this.m_buttonRefer.addSelectionListener((SelectionListener)new JobIdSelectionListener(this.m_textJobId));
        label = new Label((Composite)this, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        this.m_checkInhibitionFlg = this.getCheckBox(this, 3);
        label = new Label((Composite)this, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        this.m_comboFailurePriority = this.getComboPriority(this, 2);
        label = new Label((Composite)this, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
    }

    public void setInputData(MonitorStringValueInfo info) {
        if (info != null) {
            if (info.getJobId() != null) {
                this.m_textJobId.setText(info.getJobId());
            }
            this.m_checkInhibitionFlg.setSelection(YesNoConstant.typeToBoolean(info.getJobInhibitionFlg()));
            this.m_comboFailurePriority.setText(PriorityConstant.typeToString(info.getJobFailurePriority()));
        }
    }

    public ValidateResult createInputData(MonitorStringValueInfo info) {
        ValidateResult validateResult = this.setMonitorStringValueInfo(info, this.m_textJobId, this.m_checkInhibitionFlg, this.m_comboFailurePriority, 1);
        return validateResult;
    }

    public ValidateResult setMonitorStringValueInfo(MonitorStringValueInfo info, Text textJobId, Button checkInhibitionFlg, Combo comboFailurePriority, int truthValue) {
        String jobId = textJobId.getText();
        Integer jobInhibitionFlg = YesNoConstant.booleanToType(checkInhibitionFlg.getSelection());
        Integer jobFailurePriority = PriorityConstant.stringToType(comboFailurePriority.getText());
        if (info == null) {
            info = new MonitorStringValueInfo();
        }
        if (jobId != null && !"".equals(jobId.trim())) {
            info.setJobId(jobId);
        } else if (info.getJobRun() == 1) {
            Object[] args = new String[]{""};
            return this.setValidateResult(Messages.getString("message.hinemos.1"), Messages.getString("message.monitor.25", args));
        }
        info.setJobInhibitionFlg(jobInhibitionFlg);
        info.setJobFailurePriority(jobFailurePriority);
        return null;
    }

    public void setEnabled(boolean enabled) {
        this.setEnabled(enabled, this.m_textJobId, this.m_buttonRefer, this.m_checkInhibitionFlg, this.m_comboFailurePriority);
    }

    public void setEnabled(boolean enabled, Text textJobId, Button buttonRefer, Button checkInhibitionFlg, Combo comboFailurePriority) {
        textJobId.setEnabled(enabled);
        buttonRefer.setEnabled(enabled);
        checkInhibitionFlg.setEnabled(enabled);
        comboFailurePriority.setEnabled(enabled);
    }

    protected Combo getComboPriority(Composite parent, int horizontalSpan) {
        Combo combo = new Combo((Composite)this, 12);
        GridData gridData = new GridData();
        gridData.horizontalSpan = horizontalSpan;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        combo.setLayoutData((Object)gridData);
        combo.add(PriorityConstant.STRING_CRITICAL);
        combo.add(PriorityConstant.STRING_WARNING);
        combo.add(PriorityConstant.STRING_INFO);
        combo.add(PriorityConstant.STRING_UNKNOWN);
        combo.setText(PriorityConstant.STRING_UNKNOWN);
        return combo;
    }

    protected Button getCheckBox(Composite parent, int horizontalSpan) {
        Button button = new Button(parent, 32);
        GridData gridData = new GridData();
        gridData.horizontalSpan = horizontalSpan;
        gridData.horizontalAlignment = 2;
        gridData.grabExcessHorizontalSpace = true;
        button.setLayoutData((Object)gridData);
        return button;
    }

    protected Text getTextJobId(Composite parent, int horizontalSpan) {
        Text text = new Text((Composite)this, 18440);
        GridData gridData = new GridData();
        gridData.horizontalSpan = horizontalSpan;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        text.setLayoutData((Object)gridData);
        return text;
    }

    protected Button getButtonRefer(Composite parent, int horizontalSpan) {
        Button button = new Button((Composite)this, 0);
        GridData gridData = new GridData();
        gridData.horizontalSpan = horizontalSpan;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        button.setLayoutData((Object)gridData);
        button.setText(Messages.getString("refer"));
        return button;
    }

    protected ValidateResult setValidateResult(String id, String message) {
        ValidateResult validateResult = new ValidateResult();
        validateResult.setValid(false);
        validateResult.setID(id);
        validateResult.setMessage(message);
        return validateResult;
    }
}

