/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide.dialogs;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.ide.dialogs.MultiStepWizard;
import org.eclipse.ui.internal.ide.dialogs.MultiStepWizardDialog;
import org.eclipse.ui.internal.ide.dialogs.WizardStep;
import org.eclipse.ui.internal.ide.misc.WizardStepGroup;

public class MultiStepConfigureWizardPage
extends WizardPage {
    private MultiStepWizardDialog wizardDialog;
    private Composite pageSite;
    private WizardStepGroup stepGroup;
    private WizardStepContainer stepContainer = new WizardStepContainer();

    public MultiStepConfigureWizardPage(String pageName) {
        super(pageName);
    }

    public boolean canFlipToNextPage() {
        return this.stepContainer.canFlipToNextPage();
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        composite.setFont(parent.getFont());
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.eclipse.ui.ide.new_project_configure_wizard_page_context");
        this.createStepGroup(composite);
        this.createEmbeddedPageSite(composite);
        this.setControl((Control)composite);
    }

    private void createEmbeddedPageSite(Composite parent) {
        this.pageSite = new Composite(parent, 0);
        this.pageSite.setLayout((Layout)new GridLayout());
        this.pageSite.setLayoutData((Object)new GridData(1808));
    }

    private void createStepGroup(Composite parent) {
        this.stepGroup = new WizardStepGroup();
        this.stepGroup.createContents(parent);
    }

    WizardStepContainer getStepContainer() {
        return this.stepContainer;
    }

    public String getMessage() {
        String msg = this.stepContainer.getMessage();
        if (msg == null || msg.length() == 0) {
            msg = super.getMessage();
        }
        return msg;
    }

    public IWizardPage getPreviousPage() {
        return this.stepContainer.getPreviousPage();
    }

    public void setPreviousPage(IWizardPage page) {
        super.setPreviousPage(null);
    }

    void setSteps(WizardStep[] steps) {
        if (this.stepGroup != null) {
            this.stepGroup.setSteps(steps);
        }
    }

    void setWizardDialog(MultiStepWizardDialog dialog) {
        this.wizardDialog = dialog;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        WizardStep[] steps = this.stepGroup.getSteps();
        MultiStepWizard stepWizard = this.wizardDialog.getMultiStepWizard();
        this.wizardDialog.setFinishLabel(stepWizard.getFinishStepLabel(steps));
        this.getControl().getDisplay().asyncExec(new Runnable(){

            public void run() {
                MultiStepConfigureWizardPage.this.stepContainer.processCurrentStep();
            }
        });
    }

    class WizardStepContainer
    implements IWizardContainer {
        private int stepIndex = 0;
        private IWizard wizard;
        private IWizardPage currentPage;

        WizardStepContainer() {
        }

        public void run(boolean fork, boolean cancelable, IRunnableWithProgress runnable) throws InvocationTargetException, InterruptedException {
            MultiStepConfigureWizardPage.this.getContainer().run(fork, cancelable, runnable);
        }

        public IWizardPage getCurrentPage() {
            return this.currentPage;
        }

        public Shell getShell() {
            return MultiStepConfigureWizardPage.this.getContainer().getShell();
        }

        public void showPage(IWizardPage page) {
            this.showPage(page, true);
        }

        public void updateButtons() {
            MultiStepConfigureWizardPage.this.getContainer().updateButtons();
        }

        public void updateMessage() {
            MultiStepConfigureWizardPage.this.getContainer().updateMessage();
        }

        public void updateTitleBar() {
            MultiStepConfigureWizardPage.this.getContainer().updateTitleBar();
        }

        public void updateWindowTitle() {
            MultiStepConfigureWizardPage.this.getContainer().updateWindowTitle();
        }

        public void backPressed() {
            this.showPage(this.currentPage.getPreviousPage(), false);
        }

        public void nextPressed() {
            this.showPage(this.currentPage.getNextPage(), true);
        }

        public void helpPressed() {
            if (this.currentPage != null) {
                this.currentPage.performHelp();
            }
        }

        public final boolean performCancel() {
            if (this.wizard != null) {
                return this.wizard.performCancel();
            }
            return true;
        }

        public final boolean performFinish() {
            if (this.wizard != null) {
                if (this.wizard.performFinish()) {
                    this.wizard.dispose();
                    this.wizard.setContainer(null);
                    MultiStepConfigureWizardPage.this.stepGroup.markStepAsDone();
                    ++this.stepIndex;
                    return true;
                }
                return false;
            }
            return true;
        }

        private Point calculatePageSizeDelta(IWizardPage page) {
            Control pageControl = page.getControl();
            if (pageControl == null) {
                return new Point(0, 0);
            }
            Point contentSize = pageControl.computeSize(-1, -1, true);
            Rectangle rect = MultiStepConfigureWizardPage.this.pageSite.getClientArea();
            Point containerSize = new Point(rect.width, rect.height);
            return new Point(Math.max(0, contentSize.x - containerSize.x), Math.max(0, contentSize.y - containerSize.y));
        }

        private void updateSizeForPage(IWizardPage page) {
            Point delta = this.calculatePageSizeDelta(page);
            if (delta.x > 0 || delta.y > 0) {
                Point siteSize = MultiStepConfigureWizardPage.this.pageSite.getSize();
                GridData data = (GridData)MultiStepConfigureWizardPage.this.pageSite.getLayoutData();
                data.heightHint = siteSize.y + delta.y;
                data.widthHint = siteSize.x + delta.x;
            }
        }

        private void updateSizeForWizard(IWizard wizard) {
            Point delta = new Point(0, 0);
            IWizardPage[] pages = wizard.getPages();
            int i = 0;
            while (i < pages.length) {
                Point pageDelta = this.calculatePageSizeDelta(pages[i]);
                delta.x = Math.max(delta.x, pageDelta.x);
                delta.y = Math.max(delta.y, pageDelta.y);
                ++i;
            }
            if (delta.x > 0 || delta.y > 0) {
                Point siteSize = MultiStepConfigureWizardPage.this.pageSite.getSize();
                GridData data = (GridData)MultiStepConfigureWizardPage.this.pageSite.getLayoutData();
                data.heightHint = siteSize.y + delta.y;
                data.widthHint = siteSize.x + delta.x;
            }
        }

        public void processCurrentStep() {
            WizardStep[] steps = MultiStepConfigureWizardPage.this.stepGroup.getSteps();
            while (this.stepIndex < steps.length) {
                if (this.stepIndex == steps.length - 1) {
                    MultiStepConfigureWizardPage.this.wizardDialog.setFinishLabel(null);
                }
                WizardStep step = steps[this.stepIndex];
                MultiStepConfigureWizardPage.this.stepGroup.setCurrentStep(step);
                IWizard[] stepWizard = new IWizard[1];
                BusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)new Runnable(this, stepWizard, step){
                    final /* synthetic */ WizardStepContainer this$1;
                    private final /* synthetic */ IWizard[] val$stepWizard;
                    private final /* synthetic */ WizardStep val$step;
                    {
                        this.this$1 = wizardStepContainer;
                        this.val$stepWizard = iWizardArray;
                        this.val$step = wizardStep;
                    }

                    public void run() {
                        this.val$stepWizard[0] = this.val$step.getWizard();
                        int tries = 0;
                        while (this.val$stepWizard[0] == null && tries++ < 3) {
                            boolean tryAgain = MultiStepConfigureWizardPage.access$3(WizardStepContainer.access$0(this.this$1)).getMultiStepWizard().handleMissingStepWizard(this.val$step);
                            if (!tryAgain) break;
                            this.val$stepWizard[0] = this.val$step.getWizard();
                        }
                    }
                });
                if (stepWizard[0] == null) break;
                this.setWizard(stepWizard[0]);
                if (stepWizard[0].getPageCount() > 0) {
                    return;
                }
                this.performFinish();
            }
            MultiStepConfigureWizardPage.this.wizardDialog.forceClose();
        }

        public void setWizard(IWizard newWizard) {
            this.wizard = newWizard;
            this.wizard.createPageControls(MultiStepConfigureWizardPage.this.pageSite);
            IWizardPage[] pages = this.wizard.getPages();
            int i = 0;
            while (i < pages.length) {
                IWizardPage page = pages[i];
                if (page.getControl() != null) {
                    page.getControl().setVisible(false);
                }
                ++i;
            }
            this.updateSizeForWizard(this.wizard);
            MultiStepConfigureWizardPage.this.wizardDialog.updateLayout();
            this.wizard.setContainer((IWizardContainer)this);
            this.showPage(this.wizard.getStartingPage(), false);
        }

        public void showPage(IWizardPage page, boolean rememberPrevious) {
            if (page == null || page == this.currentPage) {
                return;
            }
            if (rememberPrevious && this.currentPage != null) {
                page.setPreviousPage(this.currentPage);
            }
            if (this.wizard != page.getWizard()) {
                throw new IllegalStateException();
            }
            if (page.getControl() == null) {
                page.createControl(MultiStepConfigureWizardPage.this.pageSite);
                if (page.getControl() == null) {
                    throw new IllegalArgumentException();
                }
                this.updateSizeForPage(page);
                MultiStepConfigureWizardPage.this.wizardDialog.updateLayout();
            }
            IWizardPage oldPage = this.currentPage;
            this.currentPage = page;
            this.currentPage.setVisible(true);
            if (oldPage != null) {
                oldPage.setVisible(false);
            }
            page.getControl().setBounds(MultiStepConfigureWizardPage.this.pageSite.getClientArea());
            MultiStepConfigureWizardPage.this.wizardDialog.updateAll();
        }

        public boolean canWizardFinish() {
            if (this.wizard != null) {
                return this.wizard.canFinish();
            }
            return false;
        }

        public boolean canFlipToNextPage() {
            if (this.currentPage != null) {
                return this.currentPage.canFlipToNextPage();
            }
            return false;
        }

        public String getMessage() {
            if (this.currentPage != null) {
                return this.currentPage.getMessage();
            }
            return null;
        }

        public IWizardPage getPreviousPage() {
            if (this.currentPage != null) {
                return this.currentPage.getPreviousPage();
            }
            return null;
        }

        static /* synthetic */ MultiStepConfigureWizardPage access$0(WizardStepContainer wizardStepContainer) {
            return wizardStepContainer.MultiStepConfigureWizardPage.this;
        }
    }
}

