/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import org.eclipse.core.runtime.IProduct;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.ProgressIndicator;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.util.Geometry;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.internal.WorkbenchMessages;

public class StartupProgressMonitorDialog
extends ProgressMonitorDialog {
    private static final int MINIMUM_WIDTH = 500;
    private static int VERTICAL_OFFSET = 85;
    private static int BAR_DLUS = 9;
    private String productName = null;

    public StartupProgressMonitorDialog(Shell parent) {
        super(parent);
        this.setShellStyle(0);
    }

    private String getProductName() {
        if (this.productName == null) {
            IProduct product = Platform.getProduct();
            if (product != null) {
                this.productName = product.getName();
            }
            if (this.productName == null) {
                this.productName = WorkbenchMessages.Startup_DefaultProductName;
            }
        }
        return this.productName;
    }

    protected Control createContents(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridData gridData = new GridData(4, 4, true, true);
        container.setLayoutData((Object)gridData);
        GridLayout gridLayout = new GridLayout();
        gridLayout.horizontalSpacing = 0;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.verticalSpacing = 0;
        container.setLayout((Layout)gridLayout);
        Composite progressArea = new Composite(container, 0);
        super.createContents(progressArea);
        gridLayout = (GridLayout)progressArea.getLayout();
        gridLayout.marginHeight = gridLayout.marginWidth;
        gridData = (GridData)progressArea.getLayoutData();
        gridData.verticalAlignment = 0x1000000;
        return container;
    }

    protected Image getImage() {
        return null;
    }

    protected Control createDialogArea(Composite parent) {
        this.progressIndicator = new ProgressIndicator(parent);
        GridData gd = new GridData();
        gd.heightHint = this.convertVerticalDLUsToPixels(BAR_DLUS);
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        this.progressIndicator.setLayoutData((Object)gd);
        this.subTaskLabel = new Label(parent, 16384);
        gd = new GridData(768);
        gd.minimumWidth = 250;
        this.subTaskLabel.setLayoutData((Object)gd);
        this.subTaskLabel.setFont(parent.getFont());
        Label productLabel = new Label(parent, 131072);
        productLabel.moveBelow((Control)this.subTaskLabel);
        gd = new GridData(131072);
        productLabel.setLayoutData((Object)gd);
        productLabel.setFont(parent.getFont());
        productLabel.setText(this.getProductName());
        return parent;
    }

    protected Point getInitialLocation(Point initialSize) {
        Point referencePoint;
        Rectangle monitorBounds;
        Composite parent = this.getShell().getParent();
        if (parent == null) {
            return super.getInitialLocation(initialSize);
        }
        Monitor monitor = parent.getMonitor();
        if (SWT.getPlatform().equals("carbon")) {
            monitorBounds = monitor.getClientArea();
            referencePoint = Geometry.centerPoint((Rectangle)monitorBounds);
            referencePoint.y = monitorBounds.height / 3 + monitorBounds.y;
        } else {
            monitorBounds = monitor.getBounds();
            referencePoint = Geometry.centerPoint((Rectangle)monitorBounds);
        }
        return new Point(referencePoint.x - initialSize.x / 2, Math.max(monitorBounds.y, Math.min(referencePoint.y + VERTICAL_OFFSET, monitorBounds.y + monitorBounds.height - initialSize.y)));
    }

    protected Point getInitialSize() {
        Point calculatedSize = this.getShell().computeSize(-1, -1, true);
        if (calculatedSize.x < 500) {
            calculatedSize.x = 500;
        }
        return calculatedSize;
    }

    protected Control createButtonBar(Composite parent) {
        return null;
    }
}

