/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.components.framework;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.ui.internal.components.Assert;
import org.eclipse.ui.internal.components.DependencyOnlyFactory;
import org.eclipse.ui.internal.components.framework.ComponentException;
import org.eclipse.ui.internal.components.framework.ComponentFactory;
import org.eclipse.ui.internal.components.framework.ComponentHandle;
import org.eclipse.ui.internal.components.framework.IServiceProvider;
import org.eclipse.ui.internal.components.framework.ServiceFactory;
import org.eclipse.ui.internal.components.util.InstanceToComponentFactoryAdapter;
import org.eclipse.ui.internal.components.util.InstanceToServiceFactoryAdapter;
import org.eclipse.ui.internal.components.util.ServiceProviderToServiceFactoryAdapter;

public final class FactoryMap
extends ServiceFactory {
    private Map adapters = null;
    private List exclusions = null;
    private List parentContexts = null;
    private List registeredContainers = null;

    public FactoryMap mapExclusion(Object interface_) {
        Assert.isNotNull(interface_);
        if (this.exclusions == null) {
            this.exclusions = new ArrayList();
        }
        this.exclusions.add(interface_);
        this.internalAddMapping(interface_, null);
        return this;
    }

    public FactoryMap map(Object interface_, ComponentFactory adapter) {
        Assert.isNotNull(adapter);
        Assert.isNotNull(interface_);
        this.internalAddMapping(interface_, adapter);
        return this;
    }

    public FactoryMap map(Object interfaceType, ServiceFactory context) {
        Assert.isNotNull(interfaceType);
        Assert.isNotNull(context);
        this.internalAddMapping(interfaceType, context);
        this.add(new DependencyOnlyFactory(context));
        return this;
    }

    public FactoryMap mapInstance(Object interfaceType, Object component) {
        Assert.isNotNull(interfaceType);
        Assert.isNotNull(component);
        if (interfaceType instanceof Class) {
            Class c = (Class)interfaceType;
            Assert.isTrue(c.isInstance(component));
        }
        return this.map(interfaceType, new InstanceToComponentFactoryAdapter(component));
    }

    public FactoryMap addInstance(Object instance) {
        return this.add(new InstanceToServiceFactoryAdapter(instance));
    }

    public FactoryMap add(ServiceFactory context) {
        Assert.isNotNull(context);
        this.internalAddInstance(context);
        return this;
    }

    public FactoryMap add(IServiceProvider toAdd) {
        Assert.isNotNull(toAdd);
        this.internalAddInstance(new ServiceProviderToServiceFactoryAdapter(toAdd));
        return this;
    }

    ComponentHandle getInstance(Object type, IServiceProvider availableDependencies) throws ComponentException {
        if (this.parentContexts == null) {
            return null;
        }
        Iterator iter = this.parentContexts.iterator();
        while (iter.hasNext()) {
            ServiceFactory context = (ServiceFactory)iter.next();
            ComponentHandle result = context.createHandle(type, availableDependencies);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public ComponentHandle createHandle(Object key, IServiceProvider availableDependencies) throws ComponentException {
        if (this.adapters != null && this.adapters.containsKey(key)) {
            ServiceFactory targetContext;
            ComponentHandle handle;
            Object target = this.adapters.get(key);
            if (target == null) {
                return null;
            }
            if (target instanceof ComponentFactory) {
                ComponentFactory factory = (ComponentFactory)target;
                return factory.createHandle(availableDependencies);
            }
            if (target instanceof ServiceFactory && (handle = (targetContext = (ServiceFactory)target).createHandle(key, availableDependencies)) != null) {
                return handle;
            }
        }
        return this.getInstance(key, availableDependencies);
    }

    private void internalAddInstance(ServiceFactory component) {
        if (this.parentContexts == null) {
            this.parentContexts = new ArrayList();
        }
        if (!this.parentContexts.contains(component)) {
            this.parentContexts.add(component);
        }
    }

    private void internalRemoveInstance(ServiceFactory component) {
        if (this.parentContexts == null) {
            return;
        }
        this.parentContexts.remove(component);
        if (this.parentContexts.isEmpty()) {
            this.parentContexts = null;
        }
    }

    private void internalAddMapping(Object interface_, Object toMap) {
        if (this.adapters == null) {
            this.adapters = new HashMap();
        }
        this.adapters.put(interface_, toMap);
    }

    private boolean hasKey(Object componentKey, ServiceFactory toSkip) {
        if (this.adapters != null && this.adapters.containsKey(componentKey)) {
            return this.adapters.get(componentKey) != null;
        }
        if (this.parentContexts != null) {
            Iterator iter = this.parentContexts.iterator();
            while (iter.hasNext()) {
                ServiceFactory context = (ServiceFactory)iter.next();
                if (context == toSkip || !context.hasService(componentKey)) continue;
                return true;
            }
        }
        return false;
    }

    public Collection getMissingDependencies() {
        HashSet result = new HashSet();
        if (this.parentContexts != null) {
            Iterator iter = this.parentContexts.iterator();
            while (iter.hasNext()) {
                ServiceFactory next = (ServiceFactory)iter.next();
                Collection inheritedDeps = next.getMissingDependencies();
                Iterator iterator = inheritedDeps.iterator();
                while (iterator.hasNext()) {
                    Object dep = iterator.next();
                    if (this.hasKey(dep, next)) continue;
                    result.add(dep);
                }
            }
        }
        if (this.exclusions != null) {
            result.addAll(this.exclusions);
        }
        return result;
    }

    public boolean hasService(Object componentKey) {
        return this.hasKey(componentKey, null);
    }
}

