/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.collectiverun.composite;

import com.clustercontrol.collectiverun.action.GetDetailInfo;
import com.clustercontrol.collectiverun.action.GetDetailTabelDefine;
import com.clustercontrol.collectiverun.bean.DetailTableDefine;
import com.clustercontrol.composite.CommonTableViewer;
import com.clustercontrol.util.Messages;
import java.util.ArrayList;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;

public class DetailComposite
extends Composite {
    protected CommonTableViewer m_viewer = null;
    protected String m_sessionId = null;
    protected Label m_sessionIdLabel = null;

    public DetailComposite(Composite parent, int style) {
        super(parent, style);
        this.initialize();
    }

    private void initialize() {
        GridLayout layout = new GridLayout(1, true);
        this.setLayout((Layout)layout);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.m_sessionIdLabel = new Label((Composite)this, 16384);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        this.m_sessionIdLabel.setLayoutData((Object)gridData);
        Table table = new Table((Composite)this, 66308);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalSpan = 1;
        table.setLayoutData((Object)gridData);
        this.m_viewer = new CommonTableViewer(table);
        this.m_viewer.createTableColumn(GetDetailTabelDefine.get(), DetailTableDefine.SORT_COLUMN_INDEX, DetailTableDefine.SORT_ORDER);
        this.update(null);
    }

    public void update(String sessionId) {
        ArrayList detailInfo = null;
        GetDetailInfo detail = new GetDetailInfo();
        if (sessionId != null && sessionId.length() > 0) {
            detailInfo = detail.getDetailInfo(sessionId);
        }
        this.m_viewer.setInput(detailInfo);
        this.m_sessionId = sessionId;
        if (this.m_sessionId != null) {
            this.m_sessionIdLabel.setText(String.valueOf(Messages.getString((String)"session.id")) + " : " + this.m_sessionId);
        } else {
            this.m_sessionIdLabel.setText(String.valueOf(Messages.getString((String)"session.id")) + " : ");
        }
    }

    public String getSessionId() {
        return this.m_sessionId;
    }

    public void setSessionId(String sessionId) {
        this.m_sessionId = sessionId;
    }
}

