/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.model;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.update.configuration.ILocalSite;
import org.eclipse.update.configurator.IPlatformConfiguration;
import org.eclipse.update.internal.configurator.PlatformConfiguration;
import org.eclipse.update.internal.core.Assert;
import org.eclipse.update.internal.core.BaseSiteLocalFactory;
import org.eclipse.update.internal.core.InstallConfiguration;
import org.eclipse.update.internal.core.SiteLocal;
import org.eclipse.update.internal.core.UpdateCore;
import org.eclipse.update.internal.core.UpdateManagerUtils;
import org.eclipse.update.internal.model.InstallConfigurationModel;
import org.eclipse.update.internal.model.SiteLocalModel;

public class SiteLocalParser {
    private PlatformConfiguration platformConfig;
    private SiteLocalModel site;
    public static final String CONFIG = "config";
    private ResourceBundle bundle;
    private BaseSiteLocalFactory factory = new BaseSiteLocalFactory();

    private ResourceBundle getResourceBundle() throws CoreException {
        ResourceBundle bundle = null;
        URL url = null;
        try {
            url = UpdateManagerUtils.asDirectoryURL(this.site.getLocationURL());
            URLClassLoader l = new URLClassLoader(new URL[]{url}, null);
            bundle = ResourceBundle.getBundle("platform", Locale.getDefault(), l);
        }
        catch (MissingResourceException e) {
            UpdateCore.warn(String.valueOf(e.getLocalizedMessage()) + ":" + url.toExternalForm());
        }
        catch (MalformedURLException e) {
            UpdateCore.warn(e.getLocalizedMessage());
        }
        return bundle;
    }

    public SiteLocalParser(IPlatformConfiguration platformConfig, ILocalSite site) throws IOException, CoreException {
        Assert.isTrue(platformConfig instanceof PlatformConfiguration);
        this.platformConfig = (PlatformConfiguration)platformConfig;
        Assert.isTrue(site instanceof SiteLocalModel);
        this.site = (SiteLocalModel)((Object)site);
        if (UpdateCore.DEBUG && UpdateCore.DEBUG_SHOW_PARSING) {
            UpdateCore.debug("Start parsing localsite:" + ((SiteLocalModel)((Object)site)).getLocationURLString());
        }
        this.bundle = this.getResourceBundle();
        this.processConfig();
    }

    private void processConfig() throws MalformedURLException, CoreException {
        String label = this.platformConfig.getConfiguration().getDate().toString();
        label = UpdateManagerUtils.getResourceString(label, this.bundle);
        this.site.setLabel(label);
        URL url = this.site.getLocationURL();
        InstallConfigurationModel config = this.factory.createInstallConfigurationModel();
        config.setLocationURLString(url.toExternalForm());
        config.setLabel(label);
        config.resolve(url, this.site.getResourceBundleURL());
        ((SiteLocal)this.site).addConfiguration((InstallConfiguration)config);
        if (UpdateCore.DEBUG && UpdateCore.DEBUG_SHOW_PARSING) {
            UpdateCore.debug("End Processing Config Tag: url:" + url.toExternalForm());
        }
    }
}

