/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.process.dialog;

import com.clustercontrol.bean.YesNoConstant;
import com.clustercontrol.composite.StringVerifyListener;
import com.clustercontrol.dialog.CommonDialog;
import com.clustercontrol.dialog.ValidateResult;
import com.clustercontrol.monitor.run.bean.MonitorCheckInfo;
import com.clustercontrol.monitor.run.bean.MonitorInfo;
import com.clustercontrol.monitor.run.composite.MonitorBasicScopeComposite;
import com.clustercontrol.monitor.run.composite.MonitorBlockComposite;
import com.clustercontrol.monitor.run.composite.MonitorRuleComposite;
import com.clustercontrol.monitor.run.composite.NumericRunJobComposite;
import com.clustercontrol.monitor.run.composite.NumericValueInfoComposite;
import com.clustercontrol.notify.composite.NotifyInfoComposite;
import com.clustercontrol.process.action.AddProcess;
import com.clustercontrol.process.action.GetProcess;
import com.clustercontrol.process.action.ModifyProcess;
import com.clustercontrol.process.bean.MonitorProcessInfo;
import com.clustercontrol.util.Messages;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ProcessCreateDialog
extends CommonDialog {
    public static final int WIDTH_TITLE = 5;
    public static final int WIDTH_VALUE = 2;
    private MonitorInfo inputData = null;
    private ValidateResult validateResult = null;
    private String monitorId = null;
    MonitorBasicScopeComposite m_monitorBasic = null;
    private MonitorRuleComposite m_monitorRule = null;
    private Text textCommand = null;
    private Text textParam = null;
    private MonitorBlockComposite m_monitorBlock = null;
    private NumericValueInfoComposite m_numericValueInfo = null;
    private NotifyInfoComposite notifyInfo = null;
    private Button m_checkJobRun = null;
    private NumericRunJobComposite m_jobRun = null;
    private Button confirmValid = null;

    public ProcessCreateDialog(Shell parent) {
        super(parent);
    }

    public ProcessCreateDialog(Shell parent, String monitorId) {
        super(parent);
        this.monitorId = monitorId;
    }

    protected void customizeDialog(Composite parent) {
        Shell shell = this.getShell();
        shell.setText(Messages.getString((String)"dialog.process.create.modify"));
        Label label = null;
        GridData gridData = null;
        GridLayout layout = new GridLayout(1, true);
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        layout.numColumns = 15;
        parent.setLayout((Layout)layout);
        this.m_monitorBasic = new MonitorBasicScopeComposite(parent, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.m_monitorBasic.setLayoutData((Object)gridData);
        label = new Label(parent, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label.setText(String.valueOf(Messages.getString((String)"monitor.rule")) + " : ");
        Group groupRule = new Group(parent, 0);
        layout = new GridLayout(1, true);
        layout.marginWidth = 5;
        layout.marginHeight = 5;
        layout.numColumns = 1;
        groupRule.setLayout((Layout)layout);
        gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        groupRule.setLayoutData((Object)gridData);
        this.m_monitorRule = new MonitorRuleComposite((Composite)groupRule, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.m_monitorRule.setLayoutData((Object)gridData);
        label = new Label((Composite)groupRule, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label.setText(String.valueOf(Messages.getString((String)"check.rule")) + " : ");
        Group groupCheckRule = new Group((Composite)groupRule, 0);
        layout = new GridLayout(1, true);
        layout.marginWidth = 5;
        layout.marginHeight = 5;
        layout.numColumns = 15;
        groupCheckRule.setLayout((Layout)layout);
        gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        groupCheckRule.setLayoutData((Object)gridData);
        label = new Label((Composite)groupCheckRule, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 5;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label.setText(String.valueOf(Messages.getString((String)"command")) + " : ");
        this.textCommand = new Text((Composite)groupCheckRule, 18432);
        gridData = new GridData();
        gridData.horizontalSpan = 8;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.textCommand.addVerifyListener((VerifyListener)new StringVerifyListener(256));
        this.textCommand.setLayoutData((Object)gridData);
        label = new Label((Composite)groupCheckRule, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label = new Label((Composite)groupCheckRule, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 5;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label.setText(String.valueOf(Messages.getString((String)"param")) + " : ");
        this.textParam = new Text((Composite)groupCheckRule, 18432);
        gridData = new GridData();
        gridData.horizontalSpan = 8;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.textParam.addVerifyListener((VerifyListener)new StringVerifyListener(256));
        this.textParam.setLayoutData((Object)gridData);
        this.textParam.setText(".*");
        label = new Label((Composite)groupCheckRule, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label = new Label(parent, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label.setText(String.valueOf(Messages.getString((String)"monitor.block")) + " : ");
        Group groupMonitorBlock = new Group(parent, 0);
        layout = new GridLayout(1, true);
        layout.marginWidth = 5;
        layout.marginHeight = 5;
        layout.numColumns = 1;
        groupMonitorBlock.setLayout((Layout)layout);
        gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        groupMonitorBlock.setLayoutData((Object)gridData);
        this.m_monitorBlock = new MonitorBlockComposite((Composite)groupMonitorBlock, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.m_monitorBlock.setLayoutData((Object)gridData);
        label = new Label(parent, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label.setText(String.valueOf(Messages.getString((String)"def.result.node")) + " : ");
        Group groupDefResultNode = new Group(parent, 0);
        layout = new GridLayout(1, true);
        layout.marginWidth = 5;
        layout.marginHeight = 5;
        layout.numColumns = 1;
        groupDefResultNode.setLayout((Layout)layout);
        gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        groupDefResultNode.setLayoutData((Object)gridData);
        this.m_numericValueInfo = new NumericValueInfoComposite((Composite)groupDefResultNode, 0, true, Messages.getString((String)"threshold.lower.limit"), Messages.getString((String)"threshold.upper.limit"), 2, Double.valueOf(0.0), null);
        this.m_numericValueInfo.setInputRange1(0, 32768);
        this.m_numericValueInfo.setInputRange2(0, 32768);
        gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.m_numericValueInfo.setLayoutData((Object)gridData);
        label = new Label(parent, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label.setText(String.valueOf(Messages.getString((String)"notify.attribute")) + " : ");
        Group groupNotifyAttribute = new Group(parent, 0);
        layout = new GridLayout(1, true);
        layout.marginWidth = 5;
        layout.marginHeight = 5;
        layout.numColumns = 1;
        groupNotifyAttribute.setLayout((Layout)layout);
        gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        groupNotifyAttribute.setLayoutData((Object)gridData);
        this.notifyInfo = new NotifyInfoComposite((Composite)groupNotifyAttribute, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.notifyInfo.setLayoutData((Object)gridData);
        this.m_checkJobRun = new Button((Composite)groupNotifyAttribute, 32);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.m_checkJobRun.setLayoutData((Object)gridData);
        this.m_checkJobRun.setText(String.valueOf(Messages.getString((String)"run")) + " : ");
        this.m_checkJobRun.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProcessCreateDialog.this.m_jobRun.setEnabled(ProcessCreateDialog.this.m_checkJobRun.getSelection());
            }
        });
        Group groupRunJob = new Group((Composite)groupNotifyAttribute, 0);
        layout = new GridLayout(1, true);
        layout.marginWidth = 5;
        layout.marginHeight = 5;
        layout.numColumns = 1;
        groupRunJob.setLayout((Layout)layout);
        gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        groupRunJob.setLayoutData((Object)gridData);
        this.m_jobRun = new NumericRunJobComposite((Composite)groupRunJob, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.m_jobRun.setLayoutData((Object)gridData);
        this.confirmValid = new Button(parent, 32);
        gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.confirmValid.setLayoutData((Object)gridData);
        this.confirmValid.setText(Messages.getString((String)"setting.valid.confirmed"));
        Label line = new Label(parent, 258);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 15;
        line.setLayoutData((Object)gridData);
        shell.pack();
        shell.setSize(new Point(550, shell.getSize().y));
        Display display = shell.getDisplay();
        shell.setLocation((display.getBounds().width - shell.getSize().x) / 2, (display.getBounds().height - shell.getSize().y) / 2);
        MonitorInfo info = null;
        info = this.monitorId != null ? new GetProcess().getProcess(this.monitorId) : new MonitorInfo();
        this.setInputData(info);
    }

    public MonitorInfo getInputData() {
        return this.inputData;
    }

    protected void setInputData(MonitorInfo monitor) {
        this.inputData = monitor;
        this.m_monitorBasic.setInputData(monitor);
        this.m_monitorRule.setInputData(monitor);
        MonitorProcessInfo processInfo = (MonitorProcessInfo)monitor.getCheckInfo();
        if (processInfo != null) {
            if (processInfo.getCommand() != null) {
                this.textCommand.setText(processInfo.getCommand());
            }
            if (processInfo.getParam() != null) {
                this.textParam.setText(processInfo.getParam());
            }
        }
        this.m_monitorBlock.setInputData(monitor);
        this.m_numericValueInfo.setInputData(monitor);
        if (monitor.getNotifyId() != null) {
            this.notifyInfo.setText(monitor.getNotifyId());
        }
        if (monitor.getApplication() != null) {
            this.notifyInfo.setApplication(monitor.getApplication());
        }
        this.m_checkJobRun.setSelection(YesNoConstant.typeToBoolean((int)monitor.getJobRun()));
        this.m_jobRun.setInputData(monitor);
        this.m_jobRun.setEnabled(YesNoConstant.typeToBoolean((int)monitor.getJobRun()));
        if (monitor.getValid() == 1) {
            this.confirmValid.setSelection(true);
        }
    }

    protected MonitorInfo createInputData() {
        MonitorInfo info = new MonitorInfo();
        info.setMonitorTypeId("PROCESS");
        info.setMonitorType(1);
        this.validateResult = this.m_monitorBasic.createInputData(info);
        if (this.validateResult != null) {
            return null;
        }
        this.validateResult = this.m_monitorRule.createInputData(info);
        if (this.validateResult != null) {
            return null;
        }
        MonitorProcessInfo processInfo = new MonitorProcessInfo();
        processInfo.setMonitorTypeId("PROCESS");
        processInfo.setMonitorId(info.getMonitorId());
        if (this.textCommand.getText() != null && !"".equals(this.textCommand.getText().trim())) {
            try {
                Pattern.compile(this.textCommand.getText());
                processInfo.setCommand(this.textCommand.getText());
            }
            catch (PatternSyntaxException patternSyntaxException) {
                this.setValidateResult(Messages.getString((String)"message.hinemos.1"), Messages.getString((String)"message.process.2"));
                return null;
            }
        } else {
            this.setValidateResult(Messages.getString((String)"message.hinemos.1"), Messages.getString((String)"message.process.1"));
            return null;
        }
        if (this.textParam.getText() != null && !"".equals(this.textParam.getText().trim())) {
            try {
                Pattern.compile(this.textParam.getText());
                processInfo.setParam(this.textParam.getText());
            }
            catch (PatternSyntaxException patternSyntaxException) {
                this.setValidateResult(Messages.getString((String)"message.hinemos.1"), Messages.getString((String)"message.process.3"));
                return null;
            }
        }
        info.setCheckInfo((MonitorCheckInfo)processInfo);
        this.validateResult = this.m_monitorBlock.createInputData(info);
        if (this.validateResult != null) {
            return null;
        }
        this.validateResult = this.m_numericValueInfo.createInputData(info);
        if (this.validateResult != null) {
            return null;
        }
        if (this.notifyInfo.getText() != null && !"".equals(this.notifyInfo.getText().trim())) {
            info.setNotifyId(this.notifyInfo.getText());
        }
        if (this.notifyInfo.getApplication() != null && !"".equals(this.notifyInfo.getApplication().trim())) {
            info.setApplication(this.notifyInfo.getApplication());
        } else if (this.notifyInfo.getText() != null && !"".equals(this.notifyInfo.getText().trim())) {
            this.setValidateResult(Messages.getString((String)"message.hinemos.1"), Messages.getString((String)"message.monitor.10"));
            return null;
        }
        info.setJobRun(YesNoConstant.booleanToType((boolean)this.m_checkJobRun.getSelection()));
        this.validateResult = this.m_jobRun.createInputData(info);
        if (this.validateResult != null) {
            return null;
        }
        if (this.confirmValid.getSelection()) {
            info.setValid(1);
        } else {
            info.setValid(0);
        }
        return info;
    }

    protected ValidateResult validate() {
        this.inputData = this.createInputData();
        if (this.inputData != null) {
            return super.validate();
        }
        return this.validateResult;
    }

    protected boolean action() {
        boolean result = false;
        MonitorInfo info = this.inputData;
        if (info != null) {
            result = this.monitorId == null ? new AddProcess().add(info) : new ModifyProcess().modify(info);
        }
        return result;
    }

    protected String getOkButtonText() {
        return Messages.getString((String)"ok");
    }

    protected String getCancelButtonText() {
        return Messages.getString((String)"cancel");
    }

    private void setValidateResult(String id, String message) {
        this.validateResult = new ValidateResult();
        this.validateResult.setValid(false);
        this.validateResult.setID(id);
        this.validateResult.setMessage(message);
    }
}

