/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.calendar.dialog;

import com.clustercontrol.bean.Property;
import com.clustercontrol.calendar.action.AddCalendarProperty;
import com.clustercontrol.calendar.action.GetCalendarProperty;
import com.clustercontrol.calendar.action.ModifyCalendarProperty;
import com.clustercontrol.composite.PropertySheet;
import com.clustercontrol.dialog.CommonDialog;
import com.clustercontrol.dialog.ValidateResult;
import com.clustercontrol.util.Messages;
import com.clustercontrol.util.PropertyUtil;
import java.util.ArrayList;
import java.util.Date;
import org.eclipse.swt.custom.TableTree;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class CalendarDialog
extends CommonDialog {
    private String id = "";
    private int mode;
    private PropertySheet propertySheet = null;

    public CalendarDialog(Shell parent, String uid, int mode) {
        super(parent);
        this.id = uid;
        this.mode = mode;
    }

    protected Point getInitialSize() {
        return new Point(500, 600);
    }

    protected void customizeDialog(Composite parent) {
        Shell shell = this.getShell();
        shell.setText(Messages.getString("dialog.calendar.calendar.create.modify"));
        GridLayout layout = new GridLayout(1, true);
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        parent.setLayout((Layout)layout);
        Label label = new Label(parent, 16384);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 1;
        label.setLayoutData((Object)gridData);
        label.setText(String.valueOf(Messages.getString("attribute")) + " : ");
        TableTree table = new TableTree(parent, 68354);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalSpan = 1;
        table.setLayoutData((Object)gridData);
        this.propertySheet = new PropertySheet(table);
        Property property = null;
        if (this.mode == 1) {
            property = new GetCalendarProperty().getProperty(this.id, 1);
        } else if (this.mode == 0) {
            property = new GetCalendarProperty().getProperty(this.id, 0);
        } else if (this.mode == 2) {
            property = new GetCalendarProperty().getProperty(this.id, 2);
        }
        this.propertySheet.setInput(property);
        this.propertySheet.expandAll();
        Label line = new Label(parent, 258);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 1;
        line.setLayoutData((Object)gridData);
        Display display = shell.getDisplay();
        shell.setLocation((display.getBounds().width - shell.getSize().x) / 2, (display.getBounds().height - shell.getSize().y) / 2);
    }

    protected ValidateResult validate() {
        ValidateResult result = null;
        ArrayList values = PropertyUtil.getPropertyValue(this.getInputData(), "id");
        String value = (String)values.get(0);
        if (value.compareTo("") == 0) {
            result = new ValidateResult();
            result.setID(Messages.getString("message.hinemos.1"));
            result.setMessage(Messages.getString("message.calendar.22"));
            result.setValid(false);
            return result;
        }
        values = PropertyUtil.getPropertyValue(this.getInputData(), "name");
        value = (String)values.get(0);
        if (value.compareTo("") == 0) {
            result = new ValidateResult();
            result.setID(Messages.getString("message.hinemos.1"));
            result.setMessage(Messages.getString("message.calendar.23"));
            result.setValid(false);
            return result;
        }
        values = PropertyUtil.getPropertyValue(this.getInputData(), "validTimeFrom");
        if (!(values.get(0) instanceof Date)) {
            result = new ValidateResult();
            result.setID(Messages.getString("message.hinemos.1"));
            Object[] args = new String[]{"(" + Messages.getString("start") + ")"};
            result.setMessage(Messages.getString("message.calendar.24", args));
            result.setValid(false);
            return result;
        }
        values = PropertyUtil.getPropertyValue(this.getInputData(), "validTimeTo");
        if (!(values.get(0) instanceof Date)) {
            result = new ValidateResult();
            result.setID(Messages.getString("message.hinemos.1"));
            Object[] args = new String[]{"(" + Messages.getString("end") + ")"};
            result.setMessage(Messages.getString("message.calendar.24", args));
            result.setValid(false);
            return result;
        }
        return result;
    }

    protected boolean action() {
        boolean result = false;
        Property property = this.getInputData();
        if (property != null) {
            result = this.mode == 1 ? new ModifyCalendarProperty().edit(property) : (this.mode == 0 ? new AddCalendarProperty().add(property) : true);
        }
        return result;
    }

    public Property getInputData() {
        return (Property)this.propertySheet.getInput();
    }

    public void setInputData(Property property) {
        this.propertySheet.setInput(property);
    }

    public String getUid() {
        return this.id;
    }

    protected String getOkButtonText() {
        if (this.mode == 1) {
            return Messages.getString("modify");
        }
        if (this.mode == 0) {
            return Messages.getString("register");
        }
        return Messages.getString("ok");
    }

    protected String getCancelButtonText() {
        return Messages.getString("cancel");
    }

    protected void okPressed() {
        ValidateResult result = this.validate();
        if (result == null || result.isValid()) {
            if (this.mode == 0) {
                this.action();
            } else {
                super.okPressed();
            }
        } else {
            this.displayError(result);
        }
    }
}

