/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.troubledetection.factory;

import java.io.File;
import java.io.FileInputStream;
import java.util.Properties;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.troubledetection.bean.TroubleDetectionInfo;

/**
 * システム通知情報検索クラス
 *
 * @version 2.1.0
 * @since 2.1.0
 */
public class SelectTroubleDetectionInfo {
	protected static Log m_log = LogFactory.getLog( SelectTroubleDetectionInfo.class );
	
	protected static TroubleDetectionInfo info = null;
	
	/**
	 * システム通知情報を取得
	 * 
	 * @return
	 */
	public TroubleDetectionInfo getInfo() {

		TroubleDetectionInfo info = new TroubleDetectionInfo();
		
	    Properties properties = new Properties();
		String homedir = System.getProperty("jboss.server.home.dir");
		String propertyFile = homedir + File.separator + "conf" + File.separator + "trouble-detection.properties";
		
		// プロパティファイルからキーと値のリストを読み込みます
		try {
			properties.load(new FileInputStream(propertyFile));
		} catch (Exception e) {
			return info;
		}

		//間隔
		String value = properties.getProperty("interval", String.valueOf(TroubleDetectionInfo.INTERVAL));
		info.setInterval(new Integer(value));

		//メール送信リトライ回数
		value = properties.getProperty("retry.mail", String.valueOf(TroubleDetectionInfo.RETRY_MAIL));
		info.setRetryMail(new Integer(value));
		
		//イベント出力リトライ回数
		value = properties.getProperty("retry.event", String.valueOf(TroubleDetectionInfo.RETRY_EVENT));
		info.setRetryEvent(new Integer(value));
		
		//ステータス出力リトライ回数
		value = properties.getProperty("retry.status", String.valueOf(TroubleDetectionInfo.RETRY_STATUS));
		info.setRetryStatus(new Integer(value));
		
		//JBossサーバ1
		value = properties.getProperty("jboss.server1", TroubleDetectionInfo.JBOSS_SERVER1);
		info.setJbossServer1(value);
		
		//JBossサーバ2
		value = properties.getProperty("jboss.server2", TroubleDetectionInfo.JBOSS_SERVER2);
		info.setJbossServer2(value);
		
		//OpenLDAPプロバイダサーバ
		value = properties.getProperty("ldap.provider", TroubleDetectionInfo.LDAP_PROVIDER);
		info.setLdapProvider(value);
		
		//OpenLDAPコンシューマサーバ
		value = properties.getProperty("ldap.consumer", TroubleDetectionInfo.LDAP_CONSUMER);
		info.setLdapConsumer(value);
		
		//Forestサーバ1
		value = properties.getProperty("forest1", TroubleDetectionInfo.FOREST1);
		info.setForest1(value);
		
		//Forestサーバ2
		value = properties.getProperty("forest2", TroubleDetectionInfo.FOREST2);
		info.setForest2(value);
		
		//SyslogForwardプロセス1
		value = properties.getProperty("syslogforward1", TroubleDetectionInfo.SYSLOG_FORWARD1);
		info.setSyslogForward1(value);
		
		//SyslogForwardプロセス2
		value = properties.getProperty("syslogforward2", TroubleDetectionInfo.SYSLOG_FORWARD2);
		info.setSyslogForward2(value);
		
		return info;
	}
}
