/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.syslogng.forward;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.repository.bean.FacilityAttributeConstant;
import com.clustercontrol.syslogng.bean.LogFilterInfo;

/**
 * フィルタとリポジトリ情報を保持するクラスです。
 * フィルタ情報と関連するファシリティ情報の一覧を格納します。
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class LogFilterRepositoryInfo {

	/**
	 * ファシリティ情報マップ。
	 * <dl>
	 *  <dt>ファシリティ情報マップ</dt>
	 *  <dd>キー：ファシリティID</dd>
	 *  <dd>値　：属性名と値のHashMap</dd>
	 * </dl>
	 */
	private HashMap m_map = new HashMap();

	/** フィルタ情報。 */
	private LogFilterInfo m_filter = null;

	/** ログ出力のインスタンス。 */
	@SuppressWarnings("unused")
	private Log log = LogFactory.getLog(this.getClass());

	/**
	 * コンストラクタ。
	 * 
	 * @param filter フィルタ情報
	 */
	public LogFilterRepositoryInfo(LogFilterInfo filter) {
		super();
		m_filter = filter;
	}

	/**
	 * ファシリティ情報を設定します。
	 * 
	 * @param map ファシリティ情報マップ
	 */
	public void setMap(HashMap map) {
		m_map = map;

		
	}
	
	
	/**
	 * ファシリティIDを返します。<BR>
	 * 引数で指定されたノード名のファシリティIDを返します。
	 * 存在しない場合は、<code> null </code>を返します。
	 * 
	 * @param value ノード名
	 * @return ファシリティID
	 */
	public String contains(String value) {

		if(value == null)
			return null;
		
		Set entrySet = m_map.entrySet();
		for (Iterator iter = entrySet.iterator(); iter.hasNext();) {
			Map.Entry  entry = (Map.Entry ) iter.next();
			HashMap attr = (HashMap)entry.getValue();
			String host = (String)attr.get(FacilityAttributeConstant.NODENAME);
			if(host != null && host.equalsIgnoreCase(value) ){
				return (String)entry.getKey();
			}
		}
		return null;
	}
	
	/**
	 * ファシリティ名を返します。
	 * 引数で指定されたファシリティIDのファシリティ名を返します。
	 * 
	 * @param facilityID ファシリティID
	 * @return ファシリティ名
	 */
	public String getNodeName(String facilityID) {

		HashMap attr = (HashMap)m_map.get(facilityID);
		return (String)attr.get(FacilityAttributeConstant.CN);
		
	}
	
	/**
	 * フィルタ情報を返します。
	 * 
	 * @return フィルタ情報
	 */
	public LogFilterInfo getFilter() {
		return m_filter;
	}
}
