/*
 
 Copyright (C) 2006 NTT DATA Corporation
 
 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License 
 as published by the Free Software Foundation, version 2.
 
 This program is distributed in the hope that it will be
 useful, but WITHOUT ANY WARRANTY; without even the implied 
 warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 PURPOSE.  See the GNU General Public License for more details.
 
 */
package com.clustercontrol.snmptrap.message;

import java.io.Serializable;

/**
 * SNMPTRAP情報更新情報クラス
 *
 * @version 2.1.0
 * @since 2.1.0
 */
public class UpdateSnmpTrapInfo implements Serializable{
	
	private static final long serialVersionUID = -8126778976946436792L;
	
	/** 登録（処理種別） */
	public static final int TYPE_ADD = 0;
	/** 更新（処理種別） */
	public static final int TYPE_UPDATE = 1;
	/** 削除（処理種別） */
	public static final int TYPE_DELETE = 2;
	
	/** 処理の種別（通知登録/変更/削除） */
	private int m_type = TYPE_ADD;
	
	/** 監視項目ID */
	String m_monitorId;
	
	public UpdateSnmpTrapInfo(){
	}
	
	public UpdateSnmpTrapInfo(int type, String monitorId) {
		m_type = type;
		m_monitorId = monitorId;
	}
	
	public int getType() {
		return m_type;
	}
	
	public void setType(int type) {
		this.m_type = type;
	}
	public String getMonitorId() {
		return m_monitorId;
	}
	
	public void setMonitorId(String id) {
		m_monitorId = id;
	}
}
