/*
 
Copyright (C) 2007 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.maintenance.action;

import java.rmi.RemoteException;
import java.util.ArrayList;

import javax.naming.NamingException;

import org.eclipse.jface.dialogs.MessageDialog;
import org.quartz.SchedulerException;

import com.clustercontrol.maintenance.ejb.session.MaintenanceController;
import com.clustercontrol.maintenance.util.EjbConnectionManager;
import com.clustercontrol.util.Messages;

/**
 * スケジュール情報を取得するクラスです。
 * 
 * @version 2.2.0
 * @since 2.2.0
 */
public class GetSchedule {

	public ArrayList getSchedule(String maintenanceId) {
		
	   	MaintenanceController maintenance = EjbConnectionManager.getConnectionManager().getMaintenanceController();
//    	Schedule schedule = null;
	   	ArrayList info = null;
    	
		try {
			info = maintenance.getSchedule(maintenanceId);
		} catch (RemoteException e) {
			// アクセス権なしの場合、エラーダイアログを表示する
			MessageDialog.openInformation(null, Messages.getString("message"),
					Messages.getString("message.accesscontrol.16"));
		} catch (NamingException e) {
		} catch (SchedulerException e) {
		}
		return info;
	}
	
    public ArrayList getScheduleList() {
    	
    	MaintenanceController maintenance = EjbConnectionManager.getConnectionManager().getMaintenanceController();
    	ArrayList records = null;
    	
		try {
			records = maintenance.getScheduleList();
		} catch (RemoteException e) {
			// アクセス権なしの場合、エラーダイアログを表示する
			MessageDialog.openInformation(null, Messages.getString("message"),
					Messages.getString("message.accesscontrol.16"));
		} catch (NamingException e) {
		} catch (SchedulerException e) {
		}
		return records;		
    }
    
}