/*
 
 Copyright (C) 2006 NTT DATA Corporation
 
 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License 
 as published by the Free Software Foundation, version 2.
 
 This program is distributed in the hope that it will be
 useful, but WITHOUT ANY WARRANTY; without even the implied 
 warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 PURPOSE.  See the GNU General Public License for more details.
 
 */

package com.clustercontrol.logtransfer.factory;

import java.util.Collection;

import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.naming.NamingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.accesscontrol.factory.AccessLock;
import com.clustercontrol.logtransfer.bean.QueueConstant;
import com.clustercontrol.logtransfer.ejb.entity.LogTransferFileInfoLocal;
import com.clustercontrol.logtransfer.ejb.entity.LogTransferInfoLocal;
import com.clustercontrol.logtransfer.ejb.entity.LogTransferInfoUtil;
import com.clustercontrol.logtransfer.message.DeleteLogTransferInfo;
import com.clustercontrol.commons.util.SendQueue;
import com.clustercontrol.util.apllog.AplLogger;

/**
 * ログ転送情報削除クラス
 *
 * @version 2.1.0
 * @since 2.1.0
 */
public class DeleteLogTransfer {
	
	protected static Log m_log = LogFactory.getLog( DeleteLogTransfer.class );
	
	/**
	 * ログ転送情報を削除
	 * 
	 * @return 削除に成功した場合、true
	 * @throws FinderException
	 * @throws RemoveException
	 * @throws NamingException
	 */
	public boolean delete(String transferId) throws FinderException, RemoveException, NamingException {
		//アクセスロック
		AccessLock.lock(AccessLock.LOG_TRANSFER);
		
		LogTransferInfoLocal logTransfer = null;
		try 
		{
			// ログ転送情報を取得
			logTransfer = LogTransferInfoUtil.getLocalHome().findByPrimaryKey(transferId);
			
			// 転送対象ログファイル情報を削除
			Collection ct = logTransfer.getLogTransferFileInfo();
			this.deleteFiles(ct);
			
		} catch (FinderException e) {
			AplLogger apllog = new AplLogger("TRANSFER", "logTransfer");
			String[] args = { transferId };
			apllog.put("SYS", "003", args);
			m_log.debug("delete():" + e.getMessage());
			throw e;
		} catch (RemoveException e) {
			AplLogger apllog = new AplLogger("TRANSFER", "logTransfer");
			String[] args = { transferId };
			apllog.put("SYS", "003", args);
			m_log.debug("delete():" + e.getMessage());
			throw e;
		} catch (NamingException e) {
			AplLogger apllog = new AplLogger("TRANSFER", "logTransfer");
			String[] args = { transferId };
			apllog.put("SYS", "003", args);
			m_log.debug("delete():" + e.getMessage());
			throw e;
		}
		
		try 
		{
			// ログ転送情報を削除
			logTransfer.remove();
			
		} catch (RemoveException e) {
			AplLogger apllog = new AplLogger("TRANSFER", "logTransfer");
			String[] args = { transferId };
			apllog.put("SYS", "003", args);
			m_log.debug("getLogTransfer():" + e.getMessage());
			throw e;
		}
		
		try {
			DeleteLogTransferInfo info = new DeleteLogTransferInfo();
			info.setTransferId(transferId);
			
			// 転送対象ログファイル管理Queueへ通知
			SendQueue queue = new SendQueue(QueueConstant.QUEUE_NAME_FILE_MANAGE);
			queue.put(info);
			
		} catch (Exception e) {
			m_log.debug("modify() : 更新情報送信エラー : " + e.getMessage());
		}
		
		return true;
	}
	
	/**
	 * 転送対象ログファイル情報を削除
	 * 
	 * @return 削除に成功した場合、true
	 * @throws RemoveException
	 */
	public boolean deleteFiles(Collection ct) throws RemoveException {
		
		// 転送対象ログファイル情報を削除
		if(ct != null && ct.size() > 0){
			Object[] fileArray = ct.toArray();
			for(int j = 0; j < fileArray.length; j++){
				LogTransferFileInfoLocal file = (LogTransferFileInfoLocal)fileArray[j];
				if(file != null){
					file.remove();
				}
			}
		}
		return true;
	}
}
