/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.jobmanagement.factory;

import java.util.Locale;

import com.clustercontrol.bean.Property;
import com.clustercontrol.bean.PropertyConstant;
import com.clustercontrol.bean.StatusConstant;
import com.clustercontrol.jobmanagement.bean.HistoryFilterPropertyConstant;
import com.clustercontrol.util.Messages;

/**
 * 履歴フィルタ用プロパティを作成するクラスです。
 *
 * @version 1.0.0
 * @since 1.0.0
 */
public class HistoryFilterProperty extends HistoryFilterPropertyConstant {

	/**
	 * 履歴フィルタ用プロパティを返します。
	 * <p>
	 * <ol>
	 *  <li>フィルタ項目毎にID, 名前, 処理定数（{@link com.clustercontrol.bean.PropertyConstant}）を指定し、
	 *      プロパティ（{@link com.clustercontrol.bean.Property}）を生成します。</li>
	 *  <li>各フィルタ項目のプロパティをツリー状に定義します。</li>
	 * </ol>
	 * 
	 * <p>プロパティに定義するフィルタ条件は、下記の通りです。
	 * <p>
	 * <ul>
	 *  <li>プロパティ（親。ダミー）</li>
	 *  <ul>
	 *   <li>開始・再実行日時（子。テキスト）</li>
	 *   <ul>
	 *    <li>開始（孫。日時ダイアログ）</li>
	 *    <li>終了（孫。日時ダイアログ）</li>
	 *   </ul>
	 *   <li>終了・中断日時（子。テキスト）</li>
	 *   <ul>
	 *    <li>開始（孫。日時ダイアログ）</li>
	 *    <li>終了（孫。日時ダイアログ）</li>
	 *   </ul>
	 *   <li>ジョブID（子。ジョブ選択ダイアログ）</li>
	 *   <li>実行状態（子。コンボボックス）</li>
	 *  </ul>
	 * </ul>
	 * 
	 * @param locale ロケール情報
	 * @return 履歴フィルタ用プロパティ
	 * 
	 * @see com.clustercontrol.bean.Property
	 * @see com.clustercontrol.bean.PropertyConstant
	 * @see com.clustercontrol.bean.StatusConstant
	 */
	public Property getProperty(Locale locale) {
	
		//開始・再実行日時（自）
		Property m_startFromDate =
			new Property(START_FROM_DATE, Messages.getString("start", locale), PropertyConstant.EDITOR_DATETIME);
		//開始・再実行日時（至）
		Property m_startToDate =
			new Property(START_TO_DATE, Messages.getString("end", locale), PropertyConstant.EDITOR_DATETIME);
		//終了・中断日時（自）
		Property m_endFromDate =
			new Property(END_FROM_DATE, Messages.getString("start", locale), PropertyConstant.EDITOR_DATETIME);
		//終了・中断日時（至）
		Property m_endToDate =
			new Property(END_TO_DATE, Messages.getString("end", locale), PropertyConstant.EDITOR_DATETIME);
		//ジョブID
		Property m_jobId =
			new Property(JOB_ID, Messages.getString("job.id", locale), PropertyConstant.EDITOR_JOB);
		//状態
		Property m_status =
			new Property(STATUS, Messages.getString("run.status", locale), PropertyConstant.EDITOR_SELECT);

		//開始・再実行日時
		Property m_startDate = 
			new Property(START_DATE, Messages.getString("start.rerun.time", locale), PropertyConstant.EDITOR_TEXT);
		//終了・中断日時
		Property m_endDate = 
			new Property(END_DATE, Messages.getString("end.suspend.time", locale), PropertyConstant.EDITOR_TEXT);

		//値を初期化
		Object statusValues[][] = {
				{ "", StatusConstant.STRING_WAIT, StatusConstant.STRING_RESERVING, StatusConstant.STRING_RUNNING, StatusConstant.STRING_STOPPING, StatusConstant.STRING_STOP, StatusConstant.STRING_END, StatusConstant.STRING_MODIFIED }, 
				{ "", StatusConstant.STRING_WAIT, StatusConstant.STRING_RESERVING, StatusConstant.STRING_RUNNING, StatusConstant.STRING_STOPPING, StatusConstant.STRING_STOP, StatusConstant.STRING_END, StatusConstant.STRING_MODIFIED }};

		m_status.setSelectValues(statusValues);
		m_status.setValue("");
		
		m_startFromDate.setValue("");
		m_startToDate.setValue("");
		m_endFromDate.setValue("");
		m_endToDate.setValue("");
		m_jobId.setValue("");

		m_startDate.setValue("");
		m_endDate.setValue("");
		
		//変更の可/不可を設定
		m_startFromDate.setModify(PropertyConstant.MODIFY_OK);
		m_startToDate.setModify(PropertyConstant.MODIFY_OK);
		m_endFromDate.setModify(PropertyConstant.MODIFY_OK);
		m_endToDate.setModify(PropertyConstant.MODIFY_OK);
		m_jobId.setModify(PropertyConstant.MODIFY_OK);
		m_status.setModify(PropertyConstant.MODIFY_OK);

		m_startDate.setModify(PropertyConstant.MODIFY_NG);
		m_endDate.setModify(PropertyConstant.MODIFY_NG);

		Property property = new Property(null, null, "");
		
		// 初期表示ツリーを構成。
		property.removeChildren();
		property.addChildren(m_startDate);
		property.addChildren(m_endDate);
		property.addChildren(m_jobId);
		property.addChildren(m_status);
		
		// 開始・再実行日時
		m_startDate.removeChildren();
		m_startDate.addChildren(m_startFromDate);
		m_startDate.addChildren(m_startToDate);

		// 終了・中断日時
		m_endDate.removeChildren();
		m_endDate.addChildren(m_endFromDate);
		m_endDate.addChildren(m_endToDate);
		
		return property;
	}
}
