/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.jobmanagement.view.action;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;

import com.clustercontrol.dialog.CalendarDialog;
import com.clustercontrol.jobmanagement.view.RunScheduleDetailListView;
import com.clustercontrol.jobmanagement.view.RunScheduleListView;

/**
 * ジョブ[実行予定]及びジョブ[実行予定詳細]ビューにて、「フィルタ」を行うアクションクラスです。
 * 
 * @version 2.0.0
 * @since 2.0.0
 */
public class ChangeBaseDateAction implements IViewActionDelegate {
	/** アクションID */
	public static final String ID = "com.clustercontrol.jobmanagement.view.action.ChangeBaseDateAction";
	/** ビュー */
    private IViewPart viewPart;

    /**
     * ビューを保持します。ワークベンチにロードされた際に呼ばれます。
     * 
     * @param viewPart ビューのインスタンス
     * 
     * @see org.eclipse.ui.IViewActionDelegate#init(org.eclipse.ui.IViewPart)
     */
    public void init(IViewPart viewPart) {
        this.viewPart = viewPart;
    }

    /**
     * ジョブ[実行予定]またはジョブ[実行予定詳細]ビューの「フィルタ」が押された場合に、<BR>
     * ジョブ[実行予定]またはジョブ[実行予定詳細]ビューを更新します。
     * <p>
	 * <ol>
	 * <li>カレンダダイアログを表示し、選択された日付を基準日とします。</li>
	 * <li>取得した基準日を元に、ジョブ[実行予定]またはジョブ[実行予定詳細]ビューを更新します。</li>
	 * </ol>
     * 
     * @see org.eclipse.ui.IActionDelegate#run(org.eclipse.jface.action.IAction)
     * @see com.clustercontrol.dialog.CalendarDialog
     * @see com.clustercontrol.jobmanagement.view.RunScheduleListView#update()
     * @see com.clustercontrol.jobmanagement.view.RunScheduleDetailListView#update(String)
     */
    public void run(IAction action) {
    	// ダイアログを生成
    	CalendarDialog dialog = new CalendarDialog(this.viewPart.getSite().getShell());
    	
    	// ダイアログにて変更が選択された場合、入力内容をもって登録を行う。
    	if(dialog.open() == IDialogConstants.OK_ID){
            if (viewPart instanceof RunScheduleListView) { // ボタンが押された場合
            	RunScheduleListView view = (RunScheduleListView) viewPart
                        .getAdapter(RunScheduleListView.class);

        		view.setBaseDate(dialog.getDate());
        		view.update();
                
            } else if (viewPart instanceof RunScheduleDetailListView) { // ボタンが押された場合
            	RunScheduleDetailListView view = (RunScheduleDetailListView) viewPart
                        .getAdapter(RunScheduleDetailListView.class);

        		view.setBaseDate(dialog.getDate());
        		view.update(view.getListComposite().getScheduleId());
            }
    	}
    }

    /* (non-Javadoc)
     * @see org.eclipse.ui.IActionDelegate#selectionChanged(org.eclipse.jface.action.IAction, org.eclipse.jface.viewers.ISelection)
     */
    public void selectionChanged(IAction action, ISelection selection) {
    }
}