/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.collectiverun.factory;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * コマンド実行スレッドクラス
 *
 * @version 1.0.0
 * @since 1.0.0
 */
public class CommandExecutor {

    protected String m_resultMsg = "";
    protected String m_errMsg = "";
    protected int m_exitValue;
    
    //ロガー
	static private Log log = LogFactory.getLog(CommandExecutor.class);

	
	/**
	 * デバッグ用メイン処理
	 * 
	 * @param args
	 */
	public static void main(String[] args) {

		new CommandExecutor();
		
	}
	
	/**
	 * コンストラクタ
	 */
	public CommandExecutor() {
		super();
	}
	
	
    
	/**
	 * コマンド実行
	 * 
	 * @param cmd	コマンド
	 * @return	成功/失敗
	 */
	public boolean exec(String[] cmd, String inputData, String endValueStr){
		Runtime runtime = Runtime.getRuntime();

		//コマンド起動
		Process process;
		try {
			if(log.isDebugEnabled()){
				for (int i = 0; i < cmd.length; i++) {
					log.info("Command Execute:" + cmd[i]);
				}
			}
			process = runtime.exec(cmd);
		} catch (IOException e) {
			log.error(e);
			m_errMsg = e.getMessage();
			return false;
		}
		
		try {
			//標準出力リーダー
		    BufferedReader inbr = new BufferedReader(new InputStreamReader(process.getInputStream()));
			//エラー出力リーダー
			BufferedReader erbr = new BufferedReader(new InputStreamReader(process.getErrorStream()));
			//標準入力ライター
			BufferedWriter outbw = new BufferedWriter(new OutputStreamWriter(process.getOutputStream()));
			
			//標準出力用バッファ
		    StringBuffer inbuff = new StringBuffer();
			//エラー出力用バッファ
		    StringBuffer errbuff = new StringBuffer();
		    
		    //標準入力へ出力
		    if( inputData != null ){
			    try {
	                outbw.write(inputData);
	                outbw.flush();
	            } catch (IOException e1) {
	
	            }
            }
		    
            //実行完了待ちおよび、標準出力読み込み、エラー出力読み込み
		    while(true){

		        try{
		            m_exitValue = process.exitValue();
			        break;
		        }catch (IllegalThreadStateException e) {
		            try {
                        Thread.sleep(100);
                    } catch (InterruptedException e2) {
                    	break;
                    }
		        }

		        readBuff(inbr, inbuff);
		        readBuff(erbr, errbuff); 

		        int idx = inbuff.lastIndexOf(endValueStr);
                if (idx != -1) {
    			    try {
    	                outbw.write("\n");
    	                outbw.flush();
    	            } catch (IOException e1) {
    	
    	            }
                }

		    }

            readBuff(inbr, inbuff);
            readBuff(erbr, errbuff); 
		    
	        m_resultMsg = inbuff.toString();
	        m_errMsg = errbuff.toString();

		    return true;
		
		}
		finally{
			process.destroy();
		}
	}
	/**
	 * 
	 * バッファから文字列の読み出し
	 * 
	 * @param br　読み出し対象のバッファ
	 * @param result　読み出した文字列の格納バッファ
	 * @since
	 */
	public void readBuff(BufferedReader br, StringBuffer result) {

	    char[] buff = new char[256];
	    while(true){
	        try {
	            if(!br.ready()){
	                break;
	            }
                //読み込み
                int length  = br.read(buff);
                if(length == -1)
                    break;

                result.append(buff,0,length);
                log.debug(new String(buff,0,length));
                
	        } catch (IOException e) {
	            log.error(e);
	            break;
	        }
	    }
	    return ;


	}
    /**
     * @return errMsg を戻します。
     */
    public String getErrMsg() {
        return m_errMsg;
    }
    /**
     * @return exitValue を戻します。
     */
    public int getExitValue() {
        return m_exitValue;
    }
    /**
     * @return resultMsg を戻します。
     */
    public String getResultMsg() {
        return m_resultMsg;
    }
}

