/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.collectiverun.action;

import java.rmi.AccessException;
import java.util.Locale;

import org.eclipse.jface.dialogs.MessageDialog;

import com.clustercontrol.bean.Property;
import com.clustercontrol.collectiverun.ejb.session.CollectiveRunController;
import com.clustercontrol.collectiverun.util.EjbConnectionManager;
import com.clustercontrol.util.Messages;
import com.clustercontrol.util.PropertyUtil;

/**
 * 一括制御実行クラス
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class ExecuteCollectiveRun {

    /**
     * 一括制御実行処理
     * 
     * @param type
     * @param property
     * @return
     */
    public void execute(String typeId, Property property) {
        PropertyUtil.deletePropertyDefine(property);

        CollectiveRunController collectiveRun = EjbConnectionManager
                .getConnectionManager().getCollectiveRunController();

        try {
            collectiveRun.run(typeId, property, Locale.getDefault());
        } catch (Exception e) {
			if(e instanceof AccessException){
				// アクセス権なしの場合、エラーダイアログを表示する
	            MessageDialog.openInformation(null, Messages.getString("message"),
	                    Messages.getString("message.accesscontrol.16"));
			}
            // 実行エラー時、エラーダイアログを表示する
            MessageDialog.openError(null, Messages.getString("message"),
                    Messages.getString("message.collective.run.1"));

        }
    }
}