/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.calendar.composite;

import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;

import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Table;

import com.clustercontrol.calendar.action.GetCalendarSchedule;
import com.clustercontrol.calendar.action.GetCalendarScheduleTableDefine;
import com.clustercontrol.calendar.composite.action.VerticalBarSelectionListener;
import com.clustercontrol.util.Messages;

/**
 * カレンダ予定コンポジットクラス
 * 
 * @version 2.0.0
 * @since 2.0.0
 */
public class CalendarScheduleComposite extends Composite {
    protected CalendarTableViewer m_viewer = null;
    
    protected Table m_table = null;
    protected Label m_labelCount = null;
    
    protected String m_calendarId = null;
    protected Date m_base = null;

    /**
     * コンストラクタ
     * 
     * @param parent
     * @param style
     * @param base
     * @since 2.0.0
     */
    public CalendarScheduleComposite(Composite parent, int style, Date base) {
        super(parent, style);
        m_base = base;
        initialize();
    }

    /**
     * 初期化処理
     * 
     * @since 2.0.0
     */
    private void initialize() {
        GridLayout layout = new GridLayout(1, true);
        this.setLayout(layout);
        layout.marginHeight = 0;
        layout.marginWidth = 0;

        m_table = new Table(this, SWT.H_SCROLL | SWT.V_SCROLL
                | SWT.FULL_SELECTION | SWT.SINGLE | SWT.BORDER);
        m_table.setHeaderVisible(true);
        m_table.setLinesVisible(true);

        GridData gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.verticalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalSpan = 1;
        m_table.setLayoutData(gridData);

        m_labelCount = new Label(this, SWT.RIGHT);
        gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.verticalAlignment = GridData.FILL;
        m_labelCount.setLayoutData(gridData);
        
        m_viewer = new CalendarTableViewer(m_table);
        m_viewer.createTableColumn(GetCalendarScheduleTableDefine.get(m_base), 0, 1);
        
        m_viewer.getTable().getVerticalBar().addSelectionListener(
        		new VerticalBarSelectionListener(this));
    }

    /**
     * 更新処理
     * 
     * @since 2.0.0
     */
    public void update() {
        ArrayList info = null;

        //カレンダ一覧情報取得
        GetCalendarSchedule getCalendarSchedule = new GetCalendarSchedule();
        info = getCalendarSchedule.getAll(m_base);
		if(info == null){
			info = new ArrayList();
		}
		
        m_viewer.setInput(info);

        Object[] args = { DateFormat.getDateInstance().format(m_base) };
        m_labelCount.setText(Messages.getString("specified.period", args));
    }

    /**
     * このコンポジットが利用するテーブルビューアを返します。
     * 
     * @return テーブルビューア
     */
    public TableViewer getTableViewer() {
        return m_viewer;
    }

    /**
     * このコンポジットが利用するテーブルを返します。
     * 
     * @return テーブル
     */
    public Table getTable() {
        return m_viewer.getTable();
    }
    
	/**
	 * @return
	 */
	public String getCalendarId() {
		return m_calendarId;
	}
	
	/**
	 * @param calendarId
	 */
	public void setCalendarId(String calendarId) {
		m_calendarId = calendarId;
	}
	
	/**
	 * @return
	 */
	public Date getBaseDate() {
		return m_base;
	}
	
	/**
	 * @param base
	 */
	public void setCalendarId(Date base) {
		m_base = base;
	}
}