/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.bean;

import com.clustercontrol.util.Messages;

/**
 * 抑制間隔の定義を定数として格納するクラスです。
 * 
 * @version 2.1.0
 * @since 1.0.0
 */
public class ExclusionConstant {
    /** 抑制しない（種別）。 */
    public static final int TYPE_NO = 0;

    /** 回数で抑制する（種別）。 */
    public static final int TYPE_FREQUENCY = 1;

    /** 期間で抑制する（分単位）（種別）。 */
    public static final int TYPE_PERIOD = 2;

    /** 重要度で抑制する（種別）。 */
    public static final int TYPE_PRIORITY = 3;
    
    /** 抑制しない（文字列）。 */
    public static final String STRING_NO = Messages.getString("suppress.no");

    /** 回数で抑制する（文字列）。 */
    public static final String STRING_FREQUENCY = Messages.getString("suppress.by.counter");

    /** 期間で抑制する（分単位）（文字列）。 */
    public static final String STRING_PERIOD = Messages.getString("suppress.by.time.interval");

    /** 重要度で抑制する（文字列）。 */
    public static final String STRING_PRIORITY = Messages.getString("suppress.by.priority");

    /**
     * 種別から文字列に変換します。
	 * 
	 * @param type 種別
	 * @return 文字列
     */
    public static String typeToString(int type) {
        if (type == TYPE_NO) {
            return STRING_NO;
        } else if (type == TYPE_FREQUENCY) {
            return STRING_FREQUENCY;
        } else if (type == TYPE_PERIOD) {
            return STRING_PERIOD;
        } else if (type == TYPE_PRIORITY) {
            return STRING_PRIORITY;
        }
        return "";
    }

    /**
     * 文字列から種別に変換します。
	 * 
	 * @param string 文字列
	 * @return 種別
     */
    public static int stringToType(String string) {
        if (string.equals(STRING_NO)) {
            return TYPE_NO;
        } else if (string.equals(STRING_FREQUENCY)) {
            return TYPE_FREQUENCY;
        } else if (string.equals(STRING_PERIOD)) {
            return TYPE_PERIOD;
        } else if (string.equals(STRING_PRIORITY)) {
            return TYPE_PRIORITY;
        }
        return -1;
    }
}