/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.accesscontrol.etc.action;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PlatformUI;

import com.clustercontrol.accesscontrol.dialog.LoginDialog;
import com.clustercontrol.util.LoginManager;
import com.clustercontrol.util.Messages;
import com.clustercontrol.util.PerspectiveUtil;

/**
 * ログインを行うアクションクラスです。
 * 
 * @version 2.0.0
 * @since 2.0.0
 */
public class LoginAction implements IWorkbenchWindowActionDelegate {
	/** アクションID */
	public static final String ID = "com.clustercontrol.accesscontrol.etc.action.LoginAction";
	/** ワークベンチウィンドウ */
	private IWorkbenchWindow m_window;
	
	/* (non-Javadoc)
	 * @see org.eclipse.ui.IWorkbenchWindowActionDelegate#dispose()
	 */
	public void dispose() {

	}

    /**
     * ワークベンチウィンドウを保持します。
     * 
     * @param window ワークベンチウィンドウ
     * 
	 * @see org.eclipse.ui.IWorkbenchWindowActionDelegate#init(org.eclipse.ui.IWorkbenchWindow)
	 */
	public void init(IWorkbenchWindow window) {
		m_window = window;
	}

	/**
	 * アクセス[ログイン]ダイアログを表示し、ログインを行います。
	 * 
	 * @see org.eclipse.ui.IActionDelegate#run(org.eclipse.jface.action.IAction)
	 */
	public void run(IAction action) {
		
		if(LoginManager.getContextManager().isLogin()){
			// 再ログイン確認ダイアログを生成
            if (!MessageDialog.openQuestion(
            		null, 
					Messages.getString("confirmed"), 
					Messages.getString("message.accesscontrol.17"))) {
            	return;
            }
		}

		//ログインダイアログ表示
        LoginDialog dialog = 
        	new LoginDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());

        //ダイアログ表示
        if (dialog.open() == IDialogConstants.OK_ID) {
        	try {
        		//ログアウト
        		LoginManager.getContextManager().logout();
        		
        		//HinemosのPerspectiveをすべて閉じる
        		PerspectiveUtil.closeAllHinemosPerspective();
        		
        		//ログイン
				LoginManager.getContextManager().login(dialog.getUserid(), dialog.getPassword());
				
	            // ログイン成功ダイアログを生成
				MessageDialog.openInformation(
						null, 
						Messages.getString("successful"), 
						Messages.getString("message.accesscontrol.5"));
			} catch (Exception e) {
                // ログイン失敗ダイアログを生成
				MessageDialog.openError(
						null, 
						Messages.getString("failed"), 
						Messages.getString("message.accesscontrol.6"));
			}
        }
	}

	/* (non-Javadoc)
	 * @see org.eclipse.ui.IActionDelegate#selectionChanged(org.eclipse.jface.action.IAction, org.eclipse.jface.viewers.ISelection)
	 */
	public void selectionChanged(IAction action, ISelection selection) {

	}
}
