/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.transport.multiplex;

public abstract class StoppableThread
extends Thread {
    protected boolean running = false;
    protected boolean stopped = true;
    protected boolean terminatedOnError = false;

    public void run() {
        this.running = true;
        this.stopped = false;
        this.doInit();
        while (this.running) {
            this.doRun();
        }
        this.doShutDown();
        this.stopped = true;
    }

    protected abstract void doInit();

    protected abstract void doRun();

    protected abstract void doShutDown();

    public synchronized boolean isRunning() {
        return this.running;
    }

    public synchronized boolean isStopped() {
        return this.stopped;
    }

    public synchronized void shutdown() {
        this.running = false;
    }
}

