/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.proxy.compiler;

import org.apache.bcel.generic.BasicType;
import org.apache.bcel.generic.ObjectType;
import org.apache.bcel.generic.Type;
import org.jboss.util.UnreachableStatementException;

public abstract class Utility
extends org.apache.bcel.classfile.Utility {
    public static Type getType(Class clazz) {
        if (clazz.isPrimitive()) {
            if (clazz.equals(Boolean.TYPE)) {
                return Type.BOOLEAN;
            }
            if (clazz.equals(Byte.TYPE)) {
                return Type.BYTE;
            }
            if (clazz.equals(Character.TYPE)) {
                return Type.CHAR;
            }
            if (clazz.equals(Double.TYPE)) {
                return Type.DOUBLE;
            }
            if (clazz.equals(Float.TYPE)) {
                return Type.FLOAT;
            }
            if (clazz.equals(Integer.TYPE)) {
                return Type.INT;
            }
            if (clazz.equals(Long.TYPE)) {
                return Type.LONG;
            }
            if (clazz.equals(Short.TYPE)) {
                return Type.SHORT;
            }
            if (clazz.equals(Void.TYPE)) {
                return Type.VOID;
            }
            throw new UnreachableStatementException();
        }
        String name = clazz.getName();
        if (clazz.isArray()) {
            return Type.getType((String)name);
        }
        return new ObjectType(name);
    }

    public static Type[] getTypes(Class[] classes) {
        Type[] types = new Type[classes.length];
        for (int i = 0; i < classes.length; ++i) {
            types[i] = Utility.getType(classes[i]);
        }
        return types;
    }

    public static String getObjectEquivalentClassName(BasicType t) {
        switch (t.getType()) {
            case 10: {
                return "java.lang.Integer";
            }
            case 9: {
                return "java.lang.Short";
            }
            case 4: {
                return "java.lang.Boolean";
            }
            case 5: {
                return "java.lang.Character";
            }
            case 8: {
                return "java.lang.Byte";
            }
            case 6: {
                return "java.lang.Float";
            }
            case 7: {
                return "java.lang.Double";
            }
            case 11: {
                return "java.lang.Long";
            }
        }
        throw new IllegalArgumentException("Unexpected Type: " + t);
    }
}

