/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.syslogng.factory;

import com.clustercontrol.accesscontrol.factory.AccessLock;
import com.clustercontrol.bean.ValidConstant;
import com.clustercontrol.syslogng.bean.LogFilterInfo;
import com.clustercontrol.syslogng.ejb.entity.SyslogMonitorRuleLocal;
import com.clustercontrol.syslogng.ejb.entity.SyslogMonitorRuleLocalHome;
import com.clustercontrol.syslogng.ejb.entity.SyslogMonitorRuleUtil;
import com.clustercontrol.syslogng.message.UpdateMonitorRuleInfo;
import com.clustercontrol.syslogng.util.SendTopic;
import com.clustercontrol.util.apllog.AplLogger;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ModifyMonitorRule {
    protected static Log m_log = LogFactory.getLog(ModifyMonitorRule.class);

    public boolean createMonitorRule(ArrayList list, String user) throws CreateException, NamingException {
        AccessLock.lock((String)"MONITOR_SYSLOG");
        if (list == null) {
            return true;
        }
        try {
            SyslogMonitorRuleLocalHome monitorRuleHome = SyslogMonitorRuleUtil.getLocalHome();
            SyslogMonitorRuleLocal monitorRule = null;
            Timestamp regDate = null;
            Timestamp updateDate = new Timestamp(new Date().getTime());
            String regUser = null;
            for (int index = 0; index < list.size(); ++index) {
                if (!(list.get(index) instanceof LogFilterInfo)) continue;
                LogFilterInfo filterInfo = (LogFilterInfo)list.get(index);
                regDate = filterInfo.getRegDate() != null ? new Timestamp(filterInfo.getRegDate().getTime()) : updateDate;
                regUser = filterInfo.getRegUser() != null && !"".equals(filterInfo.getRegUser().trim()) ? filterInfo.getRegUser() : user;
                monitorRule = monitorRuleHome.create(new Integer(filterInfo.getOrderNo()), filterInfo.getDescription(), filterInfo.getFacilityId(), filterInfo.getPattern(), new Integer(filterInfo.getProcessType()), new Integer(filterInfo.getPriority()), filterInfo.getMonitorId(), filterInfo.getApplication(), filterInfo.getMessageId(), filterInfo.getMessage(), filterInfo.getNotifyId(), filterInfo.getCalendarId(), filterInfo.getJobRun(), filterInfo.getJobId(), filterInfo.getJobInhibitionFlg(), filterInfo.getJobFailurePriority(), new Integer(ValidConstant.booleanToType((boolean)filterInfo.isValidFlg())), regDate, updateDate, regUser, user);
            }
            try {
                SendTopic send = new SendTopic("topic/clustercontrol/Repository/update");
                send.put(new UpdateMonitorRuleInfo());
            }
            catch (Exception e) {
                m_log.debug((Object)("createMonitorRule() : \u66f4\u65b0\u60c5\u5831\u9001\u4fe1\u30a8\u30e9\u30fc : " + e.getMessage()));
            }
            return true;
        }
        catch (CreateException e) {
            AplLogger apllog = new AplLogger("SLOGNG", "slogng");
            Object[] args = new String[]{"insert"};
            apllog.put("SYS", "002", args);
            m_log.debug((Object)("createMonitorRule():" + e.getMessage()));
            throw e;
        }
        catch (NamingException e) {
            AplLogger apllog = new AplLogger("SLOGNG", "slogng");
            Object[] args = new String[]{"insert"};
            apllog.put("SYS", "002", args);
            m_log.debug((Object)("createMonitorRule():" + e.getMessage()));
            throw e;
        }
    }

    public boolean deleteMonitorRule() throws RemoveException, FinderException, NamingException {
        AccessLock.lock((String)"MONITOR_SYSLOG");
        try {
            SyslogMonitorRuleLocalHome moniterRuleHome = SyslogMonitorRuleUtil.getLocalHome();
            Collection ct = moniterRuleHome.findAll();
            for (SyslogMonitorRuleLocal moniterRule : ct) {
                moniterRuleHome.remove(moniterRule.getPrimaryKey());
            }
            return true;
        }
        catch (RemoveException e) {
            AplLogger apllog = new AplLogger("SLOGNG", "slogng");
            Object[] args = new String[]{"delete"};
            apllog.put("SYS", "002", args);
            m_log.debug((Object)("createMonitorRule():" + e.getMessage()));
            throw e;
        }
        catch (FinderException e) {
            AplLogger apllog = new AplLogger("SLOGNG", "slogng");
            Object[] args = new String[]{"delete"};
            apllog.put("SYS", "002", args);
            m_log.debug((Object)("createMonitorRule():" + e.getMessage()));
            throw e;
        }
        catch (NamingException e) {
            AplLogger apllog = new AplLogger("SLOGNG", "slogng");
            Object[] args = new String[]{"delete"};
            apllog.put("SYS", "002", args);
            m_log.debug((Object)("createMonitorRule():" + e.getMessage()));
            throw e;
        }
    }
}

