/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.snmptrap.ejb.mdb;

import com.clustercontrol.monitor.message.LogOutputNotifyInfo;
import com.clustercontrol.repository.ejb.session.RepositoryControllerLocal;
import com.clustercontrol.repository.ejb.session.RepositoryControllerUtil;
import com.clustercontrol.snmptrap.bean.MonitorSnmpTrapInfo;
import com.clustercontrol.snmptrap.bean.MonitorSnmpTrapOidInfo;
import com.clustercontrol.snmptrap.bean.SnmpTrapMasterInfo;
import com.clustercontrol.snmptrap.ejb.entity.SnmpTrapMasterPK;
import com.clustercontrol.snmptrap.factory.SelectMonitorInfo;
import com.clustercontrol.snmptrap.message.SnmpTrapMessageInfo;
import com.clustercontrol.snmptrap.util.SendQueue;
import com.clustercontrol.util.Messages;
import java.io.Serializable;
import java.util.ArrayList;
import javax.ejb.EJBException;
import javax.ejb.MessageDrivenBean;
import javax.ejb.MessageDrivenContext;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class NotifySnmpTrapBean
implements MessageDrivenBean,
MessageListener {
    protected static Log m_log = LogFactory.getLog(NotifySnmpTrapBean.class);
    private MessageDrivenContext messageContext = null;

    public void setMessageDrivenContext(MessageDrivenContext messageContext) throws EJBException {
        this.messageContext = messageContext;
    }

    public void ejbCreate() {
    }

    public void ejbRemove() {
        this.messageContext = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(Message message) {
        if (message instanceof ObjectMessage) {
            ObjectMessage objectMessage = (ObjectMessage)message;
            Serializable obj = null;
            try {
                obj = objectMessage.getObject();
            }
            catch (JMSException e) {
                m_log.error((Object)("onMessage() : \u53d7\u4fe1\u30e1\u30c3\u30bb\u30fc\u30b8\u304c\u4e0d\u6b63\u3002" + e.getMessage()));
                return;
            }
            if (obj instanceof SnmpTrapMessageInfo) {
                SendQueue sendQueue = null;
                RepositoryControllerLocal repository = null;
                try {
                    sendQueue = new SendQueue("queue/clustercontrol/Monitor/EventLog");
                    repository = RepositoryControllerUtil.getLocalHome().create();
                    SnmpTrapMessageInfo info = (SnmpTrapMessageInfo)obj;
                    String monitorId = info.getMonitorId();
                    String facilityId = info.getFacilityId();
                    String facilityPath = repository.getFacilityPath(facilityId, null);
                    String trapOid = info.getTrapOid();
                    int genericId = info.getGenericId();
                    int specificId = info.getSpecificId();
                    SelectMonitorInfo select = new SelectMonitorInfo();
                    MonitorSnmpTrapInfo snmpTrapInfo = select.getMonitorInfo(monitorId);
                    ArrayList<MonitorSnmpTrapOidInfo> oidList = snmpTrapInfo.getOidInfos();
                    for (int i = 0; i < oidList.size(); ++i) {
                        String regex;
                        int j;
                        String[] values;
                        MonitorSnmpTrapOidInfo oidInfo = oidList.get(i);
                        if (!trapOid.equals(oidInfo.getTrapOid()) || genericId != oidInfo.getGenericId() || specificId != oidInfo.getSpecificId()) continue;
                        String mib = oidInfo.getMib();
                        int priority = oidInfo.getPriority();
                        String msg = oidInfo.getLogmsg();
                        String msgOrg = oidInfo.getDescr();
                        SnmpTrapMasterPK pk = new SnmpTrapMasterPK(mib, trapOid, genericId, specificId);
                        SnmpTrapMasterInfo master = select.getMasterInfo(pk);
                        if (msg != null && !"".equals(msg)) {
                            values = info.getVarBindValue();
                            for (j = 0; j < values.length; ++j) {
                                regex = "%parm\\[#" + Integer.toString(j + 1) + "\\]%";
                                msg = msg.replaceAll(regex, values[j]);
                            }
                        } else {
                            msg = "";
                        }
                        if (msgOrg == null || "".equals(msgOrg)) {
                            msgOrg = master.getDescr();
                        }
                        if (msgOrg != null && !"".equals(msgOrg)) {
                            values = info.getVarBindValue();
                            for (j = 0; j < values.length; ++j) {
                                regex = "%parm\\[#" + Integer.toString(j + 1) + "\\]%";
                                msgOrg = msgOrg.replaceAll(regex, values[j]);
                            }
                        } else {
                            msgOrg = "";
                        }
                        LogOutputNotifyInfo notifyInfo = new LogOutputNotifyInfo();
                        notifyInfo.setMonitorId(monitorId);
                        notifyInfo.setPluginId("SNMPTRAP");
                        notifyInfo.setPriority(priority);
                        notifyInfo.setNotifyId(snmpTrapInfo.getNotifyId());
                        notifyInfo.setApplication(snmpTrapInfo.getApplication());
                        notifyInfo.setFacilityId(facilityId);
                        notifyInfo.setScopeText(facilityPath);
                        notifyInfo.setGenerationDate(info.getTrapDate());
                        String messageId = null;
                        messageId = priority == 3 ? "001" : (priority == 2 ? "002" : (priority == 0 ? "003" : "004"));
                        notifyInfo.setMessageId(messageId);
                        notifyInfo.setMessage(msg);
                        Object[] args = new String[]{trapOid, master.getUei()};
                        notifyInfo.setMessageOrg(Messages.getString((String)"message.snmptrap.3", (Object[])args) + "\n" + msgOrg);
                        try {
                            sendQueue.put((Serializable)notifyInfo);
                            continue;
                        }
                        catch (Exception e) {
                            m_log.error((Object)("onMessage() : \u76e3\u8996\u7ba1\u7406\u30e1\u30c3\u30bb\u30fc\u30b8\u9001\u4fe1\u30a8\u30e9\u30fc : " + e.getMessage()));
                        }
                    }
                }
                catch (JMSException e) {
                    m_log.error((Object)("onMessage():" + e.getMessage()));
                }
                catch (EJBException e) {
                    m_log.error((Object)("onMessage():" + e.getMessage()));
                }
                catch (Exception e) {
                    m_log.error((Object)("onMessage():" + e.getMessage()));
                }
                finally {
                    if (repository != null) {
                        try {
                            repository.remove();
                        }
                        catch (Exception e) {
                            m_log.error((Object)("onMessage() : \u30a8\u30e9\u30fc" + e.getMessage()));
                        }
                    }
                    repository = null;
                }
            } else {
                m_log.debug((Object)("onMessage(): ObjectMessage is not an expected instance. " + obj.toString()));
            }
        }
    }
}

