/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.registry;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IWorkingSetUpdater;
import org.eclipse.ui.dialogs.IWorkingSetPage;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;

public class WorkingSetDescriptor {
    private String id;
    private String name;
    private String icon;
    private String pageClassName;
    private String updaterClassName;
    private IConfigurationElement configElement;
    private static final String ATT_ID = "id";
    private static final String ATT_NAME = "name";
    private static final String ATT_ICON = "icon";
    private static final String ATT_PAGE_CLASS = "pageClass";
    private static final String ATT_UPDATER_CLASS = "updaterClass";

    public WorkingSetDescriptor(IConfigurationElement configElement) throws CoreException {
        this.configElement = configElement;
        this.id = configElement.getAttribute(ATT_ID);
        this.name = configElement.getAttribute(ATT_NAME);
        this.icon = configElement.getAttribute(ATT_ICON);
        this.pageClassName = configElement.getAttribute(ATT_PAGE_CLASS);
        this.updaterClassName = configElement.getAttribute(ATT_UPDATER_CLASS);
        if (this.name == null) {
            throw new CoreException((IStatus)new Status(4, WorkbenchPlugin.PI_WORKBENCH, 0, "Invalid extension (missing class name): " + this.id, null));
        }
    }

    public String getDeclaringNamespace() {
        return this.configElement.getNamespace();
    }

    public IWorkingSetPage createWorkingSetPage() {
        Object page = null;
        if (this.pageClassName != null) {
            try {
                page = WorkbenchPlugin.createExtension(this.configElement, ATT_PAGE_CLASS);
            }
            catch (CoreException exception) {
                WorkbenchPlugin.log("Unable to create working set page: " + this.pageClassName, exception.getStatus());
            }
        }
        return (IWorkingSetPage)page;
    }

    public ImageDescriptor getIcon() {
        if (this.icon == null) {
            return null;
        }
        IExtension extension = this.configElement.getDeclaringExtension();
        String extendingPluginId = extension.getNamespace();
        return AbstractUIPlugin.imageDescriptorFromPlugin(extendingPluginId, this.icon);
    }

    public String getId() {
        return this.id;
    }

    public String getPageClassName() {
        return this.pageClassName;
    }

    public String getName() {
        return this.name;
    }

    public String getUpdaterClassName() {
        return this.updaterClassName;
    }

    public IWorkingSetUpdater createWorkingSetUpdater() {
        if (this.updaterClassName == null) {
            return null;
        }
        IWorkingSetUpdater result = null;
        try {
            result = (IWorkingSetUpdater)WorkbenchPlugin.createExtension(this.configElement, ATT_UPDATER_CLASS);
        }
        catch (CoreException exception) {
            WorkbenchPlugin.log("Unable to create working set updater: " + this.updaterClassName, exception.getStatus());
        }
        return result;
    }

    public boolean isDeclaringPluginActive() {
        Bundle bundle = Platform.getBundle((String)this.configElement.getNamespace());
        return bundle.getState() == 32;
    }

    public boolean isEditable() {
        return this.getPageClassName() != null;
    }
}

