/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.presentations;

import org.eclipse.jface.action.Action;
import org.eclipse.ui.internal.ViewPane;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchWindow;
import org.eclipse.ui.internal.presentations.ISelfUpdatingAction;
import org.eclipse.ui.presentations.IStackPresentationSite;

public class SystemMenuFastView
extends Action
implements ISelfUpdatingAction {
    private ViewPane viewPane;
    private IStackPresentationSite site;

    public SystemMenuFastView(IStackPresentationSite site) {
        this.site = site;
        this.setText(WorkbenchMessages.ViewPane_fastView);
        this.update();
    }

    public void setPane(ViewPane newPane) {
        this.viewPane = newPane;
        this.update();
    }

    public void update() {
        if (this.viewPane == null || !this.site.isPartMoveable(this.viewPane.getPresentablePart())) {
            this.setEnabled(false);
        } else {
            this.setEnabled(true);
            this.setChecked(this.viewPane.getPage().getActivePerspective().isFastView(this.viewPane.getViewReference()));
        }
    }

    public boolean shouldBeVisible() {
        if (this.viewPane == null || this.viewPane.getPage() == null) {
            return false;
        }
        WorkbenchWindow workbenchWindow = (WorkbenchWindow)this.viewPane.getPage().getWorkbenchWindow();
        return workbenchWindow.getShowFastViewBars() && this.viewPane != null && this.site.isPartMoveable(this.viewPane.getPresentablePart());
    }

    public void dispose() {
        this.viewPane = null;
    }

    public void run() {
        if (!this.isChecked()) {
            this.viewPane.doMakeFast();
        } else {
            this.viewPane.doRemoveFast();
        }
    }
}

