/*
 * Decompiled with CFR 0.152.
 */
package xdoclet.modules.ejb.dd;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import xdoclet.XDocletException;
import xdoclet.modules.ejb.EjbTagsHandler;
import xdoclet.modules.ejb.intf.InterfaceTagsHandler;
import xdoclet.util.DocletUtil;
import xjavadoc.XClass;
import xjavadoc.XDoc;
import xjavadoc.XMethod;
import xjavadoc.XTag;

public class SecurityTagsHandler
extends EjbTagsHandler {
    protected transient String currentSecurityRoleName;

    public String securityRoleName() throws XDocletException {
        return this.currentSecurityRoleName;
    }

    public void forAllSecurityRoles(String template) throws XDocletException {
        Collection classes = SecurityTagsHandler.getXJavaDoc().getSourceClasses();
        HashSet<String> roleSet = new HashSet<String>();
        Iterator i = classes.iterator();
        while (i.hasNext()) {
            XClass clazz = (XClass)i.next();
            SecurityTagsHandler.setCurrentClass((XClass)clazz);
            if (this.hasPermission(SecurityTagsHandler.getCurrentClass().getDoc())) {
                List permissions = SecurityTagsHandler.getCurrentClass().getDoc().getTags("ejb.permission");
                Iterator k = permissions.iterator();
                while (k.hasNext()) {
                    XTag tag = (XTag)k.next();
                    String roleName = tag.getAttributeValue("role-name");
                    if (roleName == null) continue;
                    roleSet.addAll(Arrays.asList(DocletUtil.tokenizeDelimitedToArray((String)roleName, (String)",")));
                }
            }
            List methods = SecurityTagsHandler.getCurrentClass().getMethods();
            Iterator j = methods.iterator();
            while (j.hasNext()) {
                XMethod method = (XMethod)j.next();
                SecurityTagsHandler.setCurrentMethod((XMethod)method);
                if (!this.hasPermission(SecurityTagsHandler.getCurrentMethod().getDoc()) || !InterfaceTagsHandler.isInterfaceMethod(SecurityTagsHandler.getCurrentMethod())) continue;
                List permissions = SecurityTagsHandler.getCurrentMethod().getDoc().getTags("ejb.permission");
                Iterator k = permissions.iterator();
                while (k.hasNext()) {
                    XTag tag = (XTag)k.next();
                    String role_name = tag.getAttributeValue("role-name");
                    if (role_name == null) continue;
                    roleSet.addAll(Arrays.asList(DocletUtil.tokenizeDelimitedToArray((String)role_name, (String)",")));
                }
            }
            List finders = SecurityTagsHandler.getCurrentClass().getDoc().getTags("ejb:finder");
            Iterator j2 = finders.iterator();
            while (j2.hasNext()) {
                XTag tag = (XTag)j2.next();
                String roleName = tag.getAttributeValue("role-name");
                if (roleName == null) continue;
                roleSet.addAll(Arrays.asList(DocletUtil.tokenizeDelimitedToArray((String)roleName, (String)",")));
            }
            List pk = SecurityTagsHandler.getCurrentClass().getDoc().getTags("ejb:pk");
            Iterator j3 = pk.iterator();
            while (j3.hasNext()) {
                XTag tag = (XTag)j3.next();
                String roleName = tag.getAttributeValue("role-name");
                if (roleName == null) continue;
                roleSet.addAll(Arrays.asList(DocletUtil.tokenizeDelimitedToArray((String)roleName, (String)",")));
            }
        }
        Iterator roleEnum = roleSet.iterator();
        while (roleEnum.hasNext()) {
            this.currentSecurityRoleName = (String)roleEnum.next();
            this.generate(template);
        }
    }

    private boolean hasPermission(XDoc doc) {
        return doc.hasTag("ejb:permission");
    }
}

