/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.troubledetection.output;

import com.clustercontrol.monitor.ejb.entity.EventLogUtil;
import com.clustercontrol.monitor.message.LogOutputInfo;
import java.sql.Timestamp;
import java.util.Date;
import javax.ejb.CreateException;
import javax.ejb.DuplicateKeyException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class OutputEvent {
    private static Log m_log = LogFactory.getLog(OutputEvent.class);
    private Timestamp m_outputDate = null;

    public boolean output(LogOutputInfo logOutput, Timestamp outputDate, int inhibitedFlg) {
        this.m_outputDate = outputDate;
        boolean result = false;
        try {
            this.insertEventLog(logOutput, inhibitedFlg);
            result = true;
        }
        catch (CreateException e) {
            m_log.error((Object)("outputEventLog():" + e.getMessage()));
        }
        catch (Exception e) {
            m_log.error((Object)("outputEventLog():" + e.getMessage()));
        }
        return result;
    }

    public void insertEventLog(LogOutputInfo logOutput, int inhibitedFlg) throws Exception, CreateException {
        try {
            int confirmFlg = -1;
            confirmFlg = inhibitedFlg == 1 ? logOutput.getExcludeConfirmFlg() : logOutput.getConfirmFlg();
            EventLogUtil.getLocalHome().create(logOutput.getMonitorId(), logOutput.getPluginId(), logOutput.getFacilityId(), logOutput.getScopeText(), logOutput.getApplication(), logOutput.getMessageId(), logOutput.getMessage(), logOutput.getMessageOrg(), new Integer(logOutput.getPriority()), new Integer(confirmFlg), null, new Integer(0), new Timestamp(logOutput.getGenerationDate().getTime()), this.m_outputDate, new Integer(inhibitedFlg));
        }
        catch (CreateException e) {
            if (e instanceof DuplicateKeyException) {
                Date now = new Date();
                this.m_outputDate = new Timestamp(now.getTime());
                this.insertEventLog(logOutput, inhibitedFlg);
            }
            throw e;
        }
        catch (Exception e) {
            throw e;
        }
    }
}

