/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.troubledetection.output;

import java.sql.Timestamp;
import java.util.Date;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.bean.YesNoConstant;
import com.clustercontrol.monitor.factory.CreateLogOutputInfo;
import com.clustercontrol.monitor.message.LogOutputBasicInfo;
import com.clustercontrol.monitor.message.LogOutputInfo;
import com.clustercontrol.monitor.message.ParallelLogOutputInfo;
import com.clustercontrol.notify.bean.NotifyInfo;
import com.clustercontrol.troubledetection.bean.TroubleDetectionInfo;
import com.clustercontrol.troubledetection.util.MailManager;

/**
 * ログ出力メインクラス
 *
 * @version 2.1.0
 * @since 2.1.0
 */
public class OutputLog {
	private static Log log = LogFactory.getLog( OutputLog.class );
	protected TroubleDetectionInfo troubleDetectionInfo;
	
	/**
	 * コンストラクタ
	 * 
	 * @param info
	 */
	public OutputLog(TroubleDetectionInfo info) {
		this.troubleDetectionInfo = info;
	} 
	
	/**
	 * ログ出力
	 * 
	 * @param notifyInfo
	 * @param basicInfo
	 */
	public void outputLog(NotifyInfo notifyInfo, LogOutputBasicInfo basicInfo) {
		
		if(notifyInfo != null){
			LogOutputInfo info = new CreateLogOutputInfo().get(notifyInfo, basicInfo);
			outputLog(info);
		}
		
	}
	
	/**
	 * ログ出力
	 * 
	 * @param info
	 */
	public synchronized void outputLog(LogOutputInfo info) {
		log.debug("outputLog start : MonitorId=" + info.getMonitorId() + ", MessageId" + info.getMessageId());

		if(!(info instanceof LogOutputInfo))
			return;

		Date now = new Date();
		Timestamp outputDate = new Timestamp(now.getTime());
		
		//出力抑制
		OutputControl control = new OutputControl();
		control.control(info, outputDate);
		
		//ステータス出力が成功するまでリトライ
		OutputStatus status = new OutputStatus();
		for(int i = 0; i < this.troubleDetectionInfo.getRetryStatus().intValue(); i++){
			//ステータス出力
			if(status.outputStatusInfo(info, control.getOutputDate()))
				break;
		}
		
		//イベント出力が成功するまでリトライ
		if(control.isInsertFlg()){
			int inhibitedFlg = YesNoConstant.TYPE_NO;
			if(control.isUpdateFlg())
				inhibitedFlg = YesNoConstant.TYPE_YES;
			
			OutputEvent event = new OutputEvent();
			for(int i = 0; i < this.troubleDetectionInfo.getRetryEvent().intValue(); i++){
				//イベント出力
				if(event.output(info, outputDate, inhibitedFlg))
					break;
			}
		}
		
		if(control.isInsertFlg() && !control.isUpdateFlg()){
			//メール送信
			String[] address = info.getAddress();
			if(address == null || address.length <= 0) {
				// 送信先メールアドレスが設定されていない場合は何もしない
			} else {	
				ParallelLogOutputInfo parallelInfo = new ParallelLogOutputInfo();
				parallelInfo.setLogOutputInfo(info);
				parallelInfo.setOutputDate(outputDate);
				MailManager.getMailManager().add(parallelInfo);
			}
			
			//ファイル出力
			OutputFile file = new OutputFile();
			file.output(info);
		}
		
		log.debug("outputLog end : MonitorId=" + info.getMonitorId() + ", MessageId" + info.getMessageId());
	}
}