/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.troubledetection.monitor;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;

import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.resource.adapter.jdbc.WrappedConnection;
import org.postgresforest.jdbc3.Jdbc3Connection;
import org.postgresforest.vm.jdbc.ForestConnection;

import com.clustercontrol.monitor.message.LogOutputInfo;
import com.clustercontrol.troubledetection.output.OutputLog;
import com.clustercontrol.troubledetection.util.NotifyMessages;

/**
 * PostgresFprest監視クラス
 * 
 * @version 2.1.0
 * @since 2.1.0
 */
public class MonitorForest extends MonitorBase {
	private static Log log = LogFactory.getLog(MonitorForest.class);
	
	/**
	 * 監視実行
	 * 
	 * @see com.clustercontrol.troubledetection.monitor.MonitorBase#run()
	 */
	public void run() {
		log.debug("run() start :");
		
		Connection conn = null;
		ResultSet rs = null;
		
		boolean server1 = false;
		boolean server2 = false;
		
		try {
			InitialContext iniCtx = new InitialContext();
			
			DataSource ds = (DataSource)iniCtx.lookup("java:/HinemosDS");
			conn = ds.getConnection();
//			Jdbc3Connection forestConn = 
//				(Jdbc3Connection)((WrappedConnection)conn).getUnderlyingConnection();
//			rs = forestConn.getGscMetaData().getServer();

			ForestConnection forestConn = 
				(ForestConnection)((WrappedConnection)conn).getUnderlyingConnection();
			rs = forestConn.getGscMetaData().getServer();
			
			while(rs.next()){
				String server = rs.getString(2);
				int status = rs.getInt(3);
				if(server.matches(".*" + this.troubleDetectionInfo.getForest1() + ".*")){
					if(status == 1){
						server1 = true;
					}
				}
				else if(server.matches(".*" + this.troubleDetectionInfo.getForest2() + ".*")){
					if(status == 1){
						server2 = true;
					}
				}
			}
			rs.close();
			
		} catch (NamingException e) {
			log.error("run() : PostgresForest Connection Error : " + e.getMessage());
		} catch (SQLException e) {
			log.error("run() : PostgresForest Connection Error : " + e.getMessage());
		} catch (NoClassDefFoundError e) {
			log.error("run() : PostgresForest Connection Error : " + e.getMessage());
		} finally {
			// コネクション、結果セットのクローズ
			try {
				if (rs != null) {
					rs.close();
				}
				if (conn != null) {
					conn.close();
				}
			} catch (SQLException e) {
				log.error("run() Error : " + e.getMessage());
			}
		}

		//ログ出力
		logout(server1, server2);
		
		log.debug("run() end :");
	}
	
	/**
	 * ログ出力
	 * 
	 * @param server1
	 * @param server2
	 */
	protected void logout(boolean server1, boolean server2) {
		
		String application = NotifyMessages.getString("hinemosdb.application");
		
		OutputLog output = new OutputLog(troubleDetectionInfo);
		
		//サーバ1正常、サーバ2正常
		if(server1 && server2){
			//通知情報作成
			LogOutputInfo info = new LogOutputInfo();
			//プラグインID
			info.setPluginId(PLUGIN_ID);
			//アプリケーション
			info.setApplication(application);
			//監視項目ID
			info.setMonitorId("HINEMOSDB01");
			//メッセージID
			info.setMessageId("001");
			//メッセージ、オリジナルメッセージ
			info.setMessage(NotifyMessages.getString("hinemosdb01.001.message"));
			String[] args = {this.troubleDetectionInfo.getForest1(), 
					this.troubleDetectionInfo.getForest2()};
			info.setMessageOrg(NotifyMessages.getString("hinemosdb01.001.org.message", args));
			//ファシリティID
			info.setFacilityId(FACILITY_ID);
			//スコープ
			info.setScopeText("");
			//重要度
			info.setPriority(getPriority(NotifyMessages.getString("hinemosdb01.001.priority")));
			//発生日時
			info.setGenerationDate(new Date());
			
			//ログ出力
			output.outputLog(notifyInfo, info);
		}
		//サーバ1正常、サーバ2異常
		else if(server1 && !server2){
			//通知情報作成
			LogOutputInfo info = new LogOutputInfo();
			//プラグインID
			info.setPluginId(PLUGIN_ID);
			//アプリケーション
			info.setApplication(application);
			//監視項目ID
			info.setMonitorId("HINEMOSDB01");
			//メッセージID
			info.setMessageId("002");
			//メッセージ、オリジナルメッセージ
			String[] args = {this.troubleDetectionInfo.getForest2()};
			info.setMessage(NotifyMessages.getString("hinemosdb01.002.message", args));
			info.setMessageOrg(NotifyMessages.getString("hinemosdb01.002.org.message", args));
			//ファシリティID
			info.setFacilityId(FACILITY_ID);
			//スコープ
			info.setScopeText("");
			//重要度
			info.setPriority(getPriority(NotifyMessages.getString("hinemosdb01.002.priority")));
			//発生日時
			info.setGenerationDate(new Date());
			
			//ログ出力
			output.outputLog(notifyInfo, info);
		}
		//サーバ1異常、サーバ2正常
		else if(!server1 && server2){
			//通知情報作成
			LogOutputInfo info = new LogOutputInfo();
			//プラグインID
			info.setPluginId(PLUGIN_ID);
			//アプリケーション
			info.setApplication(application);
			//監視項目ID
			info.setMonitorId("HINEMOSDB01");
			//メッセージID
			info.setMessageId("002");
			//メッセージ、オリジナルメッセージ
			String[] args = {this.troubleDetectionInfo.getForest1()};
			info.setMessage(NotifyMessages.getString("hinemosdb01.002.message", args));
			info.setMessageOrg(NotifyMessages.getString("hinemosdb01.002.org.message", args));
			//ファシリティID
			info.setFacilityId(FACILITY_ID);
			//スコープ
			info.setScopeText("");
			//重要度
			info.setPriority(getPriority(NotifyMessages.getString("hinemosdb01.002.priority")));
			//発生日時
			info.setGenerationDate(new Date());
			
			//ログ出力
			output.outputLog(notifyInfo, info);
		}
		//サーバ1異常、サーバ2異常
		else if(!server1 && !server2){
			//通知情報作成
			LogOutputInfo info = new LogOutputInfo();
			//プラグインID
			info.setPluginId(PLUGIN_ID);
			//アプリケーション
			info.setApplication(application);
			//監視項目ID
			info.setMonitorId("HINEMOSDB01");
			//メッセージID
			info.setMessageId("003");
			//メッセージ、オリジナルメッセージ
			info.setMessage(NotifyMessages.getString("hinemosdb01.003.message"));
			info.setMessageOrg(NotifyMessages.getString("hinemosdb01.003.org.message"));
			//ファシリティID
			info.setFacilityId(FACILITY_ID);
			//スコープ
			info.setScopeText("");
			//重要度
			info.setPriority(getPriority(NotifyMessages.getString("hinemosdb01.003.priority")));
			//発生日時
			info.setGenerationDate(new Date());
			
			//ログ出力
			output.outputLog(notifyInfo, info);
		}
	}
	
	/**
	 * ログ出力
	 * 
	 * @param messageId
	 */
	public void logout(String monitorId, String messageId){
		
		String application = NotifyMessages.getString("hinemosdb.application");
		String key = monitorId.toLowerCase() + "." + messageId;
		
		OutputLog output = new OutputLog(troubleDetectionInfo);

		//通知情報作成
		LogOutputInfo info = new LogOutputInfo();
		//プラグインID
		info.setPluginId(PLUGIN_ID);
		//アプリケーション
		info.setApplication(application);
		//監視項目ID
		info.setMonitorId(monitorId);
		//メッセージID
		info.setMessageId(messageId);
		//メッセージ、オリジナルメッセージ
		info.setMessage(NotifyMessages.getString(key + ".message"));
		info.setMessageOrg(NotifyMessages.getString(key + ".org.message"));
		//ファシリティID
		info.setFacilityId(FACILITY_ID);
		//スコープ
		info.setScopeText("");
		//重要度
		info.setPriority(getPriority(NotifyMessages.getString(key + ".priority")));
		//発生日時
		info.setGenerationDate(new Date());
		
		//ログ出力
		output.outputLog(notifyInfo, info);
	}
}
