/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.troubledetection.factory;

import java.io.IOException;

import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.jms.JMSException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.naming.InitialContext;
import javax.naming.NamingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.jmx.adaptor.rmi.RMIAdaptor;

import com.clustercontrol.notify.bean.NotifyInfo;
import com.clustercontrol.notify.factory.ModifySystemNotify;

/**
 * システム通知情報更新クラス
 *
 * @version 2.1.0
 * @since 2.1.0
 */
public class ModifyNotify {
	
	protected static Log m_log = LogFactory.getLog( ModifyNotify.class );
	
	public static final String LOOKUP_NAME = "jmx/invoker/RMIAdaptor";
	public static final String OBJECT_NAME = "user:name=TroubleDetection,service=TroubleDetectionService";
	public static final String OPERATION_NAME = "updateNotify";
	
	/**
	 * システム通知情報を更新
	 * 
	 * @param info
	 * @return 更新に成功した場合、true
	 * @throws CreateException
	 * @throws FinderException
	 * @throws RemoveException
	 * @throws NamingException
	 * @throws JMSException
	 */
	@SuppressWarnings("unchecked")
	public void modify(NotifyInfo info) throws CreateException, FinderException, RemoveException, NamingException, JMSException {

		//障害検知用のシステム通知情報を更新
		ModifySystemNotify modify = new ModifySystemNotify();
		modify.modify(info);
		
		try{
	        InitialContext ic = new InitialContext();
	        
	        //RMIAdaptorを取得
	        RMIAdaptor server = (RMIAdaptor) ic.lookup(LOOKUP_NAME);

	        //ObjectNameを設定
	        ObjectName name = new ObjectName(OBJECT_NAME);
	        
	        //ObjectNameのOperationNameのメソッドを実行
	        server.invoke(name, OPERATION_NAME, null, null);

		} catch (NamingException e) {
			m_log.debug("modify() : " + e.getMessage());
		} catch (MalformedObjectNameException e) {
			m_log.debug("modify() : " + e.getMessage());
		} catch (NullPointerException e) {
			m_log.debug("modify() : " + e.getMessage());
		} catch (InstanceNotFoundException e) {
			m_log.debug("modify() : " + e.getMessage());
		} catch (MBeanException e) {
			m_log.debug("modify() : " + e.getMessage());
		} catch (ReflectionException e) {
			m_log.debug("modify() : " + e.getMessage());
		} catch (IOException e) {
			m_log.debug("modify() : " + e.getMessage());
		}
	}
}
