/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.troubledetection.ejb.session;

import java.rmi.RemoteException;

import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.ejb.SessionContext;
import javax.jms.JMSException;
import javax.naming.NamingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.notify.bean.NotifyInfo;
import com.clustercontrol.troubledetection.bean.TroubleDetectionInfo;
import com.clustercontrol.troubledetection.factory.ModifyNotify;
import com.clustercontrol.troubledetection.factory.SelectNotify;
import com.clustercontrol.troubledetection.factory.SelectTroubleDetectionInfo;

/**
 *
 * <!-- begin-user-doc --> A generated session bean <!-- end-user-doc --> *
 *
 * <!-- begin-xdoclet-definition --> 
 * @ejb.bean name="TroubleDetectionController"	
 *           jndi-name="TroubleDetectionController"
 *           type="Stateless" 
 *           transaction-type="Container"
 * 
 * @jboss.depends name="jboss.j2ee:service=EJB,jndiName=AccessController"
 * @jboss.depends name="jboss.j2ee:service=EJB,jndiName=RepositoryController"
 * @jboss.depends name="jboss.j2ee:service=EJB,jndiName=NotifyController"
 * @jboss.depends name="jboss.j2ee:service=EJB,jndiName=QuartzManager"
 * @jboss.depends name="jboss.j2ee:service=EJB,jndiName=MonitorController"
 * 
 * @ejb.permission
 *     unchecked="true"
 *     method-intf="Home"
 *     
 * @ejb.permission
 *     unchecked="true"
 *     method-intf="LocalHome"
 *     
 * @ejb.permission
 *     unchecked="true"
 *     method-intf="Local"
 * 
 * <!-- end-xdoclet-definition --> 
 * @generated
 */
public abstract class TroubleDetectionControllerBean implements javax.ejb.SessionBean {
	
	protected static Log m_log = LogFactory.getLog( TroubleDetectionControllerBean.class );
	
	@SuppressWarnings("unused")
	private SessionContext m_context;
	
	public void setSessionContext(SessionContext ctx) throws EJBException, RemoteException {
		m_context = ctx;
	}
	
	/**
	 * 障害検知用システム通知情報取得
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     role-name="TroubleDetectionRead"
     *     method-intf="Remote"
	 * 
	 * @jboss.method-attributes
	 *     read-only="true"
	 *     
	 * @return
	 * @throws FinderException
	 * @throws NamingException
	 */
	public NotifyInfo getNotify() throws FinderException, NamingException {
		SelectNotify select = new SelectNotify();
		return select.getNotify();
	}
	
	/**
	 * 障害検知情報取得
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     role-name="TroubleDetectionRead"
     *     method-intf="Remote"
	 * 
	 * @jboss.method-attributes
	 *     read-only="true"
	 *     
	 * @return
	 */
	public TroubleDetectionInfo getInfo() {
		SelectTroubleDetectionInfo select = new SelectTroubleDetectionInfo();
		return select.getInfo();
	}
	
	/**
	 * 障害検知用システム通知情報更新
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     role-name="TroubleDetectionWrite"
     *     method-intf="Remote"
	 *     
	 * @return
	 * @throws JMSException 
	 * @throws NamingException 
	 * @throws RemoveException 
	 * @throws FinderException 
	 * @throws CreateException 
	 */
	public void modifyNotify(NotifyInfo info) throws CreateException, FinderException, RemoveException, NamingException, JMSException {
		ModifyNotify modify = new ModifyNotify();
		modify.modify(info);
	}
}
