/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.troubledetection.action;

import java.rmi.AccessException;
import java.rmi.RemoteException;

import org.eclipse.jface.dialogs.MessageDialog;

import com.clustercontrol.troubledetection.bean.TroubleDetectionInfo;
import com.clustercontrol.troubledetection.ejb.session.TroubleDetectionController;
import com.clustercontrol.troubledetection.util.EjbConnectionManager;
import com.clustercontrol.util.Messages;

/**
 * 障害検知情報を取得するクラスです。
 * 
 * @version 2.1.0
 * @since 2.1.0
 */
public class GetTroubleDetectionInfo {

    /**
     * 障害検知情報を返します。
     * 
     * @return 障害検知情報
     */
    public TroubleDetectionInfo getInfo() {

        TroubleDetectionController controller = 
        	EjbConnectionManager.getConnectionManager()
                .getController();

        TroubleDetectionInfo info = null;
        try {
        	info = controller.getInfo();
        } catch (RemoteException e) {
			if(e instanceof AccessException){
				// アクセス権なしの場合、エラーダイアログを表示する
	            MessageDialog.openInformation(null, Messages.getString("message"),
	                    Messages.getString("message.accesscontrol.16"));
			}
        }
        
        return info;
    }
}