/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.troubledetection.action;

import java.rmi.AccessException;
import java.rmi.RemoteException;

import javax.ejb.FinderException;
import javax.naming.NamingException;

import org.eclipse.jface.dialogs.MessageDialog;

import com.clustercontrol.notify.bean.NotifyInfo;
import com.clustercontrol.troubledetection.ejb.session.TroubleDetectionController;
import com.clustercontrol.troubledetection.util.EjbConnectionManager;
import com.clustercontrol.util.Messages;

/**
 * システム通知を取得するクラスです。
 * 
 * @version 2.1.0
 * @since 2.1.0
 */
public class GetSystemNotify {

    /**
     * システム通知情報を返します。
     * 
     * @return 通知情報
     */
    public NotifyInfo getSystemNotify() {

        TroubleDetectionController controller = 
        	EjbConnectionManager.getConnectionManager()
                .getController();

        NotifyInfo info = null;
        try {
        	info = controller.getNotify();
        } catch (RemoteException e) {
			if(e instanceof AccessException){
				// アクセス権なしの場合、エラーダイアログを表示する
	            MessageDialog.openInformation(null, Messages.getString("message"),
	                    Messages.getString("message.accesscontrol.16"));
			}
        } catch (FinderException e) {
        } catch (NamingException e) {
        }
        return info;
    }
}