/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.syslogng.composite;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;

import com.clustercontrol.syslogng.action.GetLogFilterListTableDefine;
import com.clustercontrol.syslogng.action.LogManager;
import com.clustercontrol.syslogng.bean.LogFilterInfo;

/**
 * ノード一覧コンポジットクラスです。
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class LogListComposite extends Composite {

    // ----- instance フィールド ----- //

    /** テーブルビューア */
    private LogFilterInfoTableViewer tableViewer = null;

    // ----- コンストラクタ ----- //

    /**
     * インスタンスを返します。
     * 
     * @param parent
     *            親のコンポジット
     * @param style
     *            スタイル
     */
    public LogListComposite(Composite parent, int style) {
        super(parent, style);

        this.initialize();
    }

    // ----- instance メソッド ----- //

    /**
     * コンポジットを生成・構築します。
     */
    private void initialize() {
        GridLayout layout = new GridLayout(1, true);
        this.setLayout(layout);
        layout.marginHeight = 0;
        layout.marginWidth = 0;

        Table table = new Table(this, SWT.MULTI | SWT.H_SCROLL | SWT.V_SCROLL
                | SWT.FULL_SELECTION);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);

        GridData gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.verticalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        table.setLayoutData(gridData);

        // テーブルビューアの作成
        this.tableViewer = new LogFilterInfoTableViewer(table);
        this.tableViewer.createTableColumn(GetLogFilterListTableDefine.get());

        gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.verticalAlignment = GridData.FILL;

        // syslog-ng一覧情報取得
        LogManager.getInstance().initialize();
        this.update();
    }

    /**
     * tableViewerを返します。
     * 
     * @return tableViewer
     */
    public LogFilterInfoTableViewer getTableViewer() {
        return this.tableViewer;
    }

    /**
     * 現在選択されているアイテムを返します。
     * <p>
     * 
     * 選択されていない場合は、nullを返します。
     * 
     * @return 選択アイテム
     */
    public LogFilterInfo getFilterItem() {
        StructuredSelection selection = (StructuredSelection) this.tableViewer
                .getSelection();

        if (selection == null) {
            return null;
        } else {
            return (LogFilterInfo) selection.getFirstElement();
        }
    }

    /**
     * コンポジットを更新します。
     * <p>
     * 
     * 検索条件が事前に設定されている場合、その条件にヒットするノードの一覧を 表示します <br>
     * 検索条件が設定されていない場合は、全ノードを表示します。
     */
    public void update() {
        // データ取得
        Object[] list = LogManager.getInstance().get();

        // テーブル更新
        this.tableViewer.setInput(list);
    }
    
    /**
     * 選択された行のログIDを取得する
     * 
     * @return 
     */
    public ArrayList<LogFilterInfo> getSelectionData() {
    	
    	ArrayList<LogFilterInfo> data = new ArrayList<LogFilterInfo>();
    	
    	//選択されたアイテムを取得
    	StructuredSelection selection = 
    		(StructuredSelection)tableViewer.getSelection();
    	List list = (List)selection.toList();
    	
    	if (list != null) {
    		for(int index = 0; index < list.size(); index++){
    			
    			LogFilterInfo info = (LogFilterInfo)list.get(index);
    			if (info instanceof LogFilterInfo) {
    				data.add(info);
    			}
    		}
    	}
    	
    	return data;
    }
}