/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.syslogng.composite;

import java.util.ArrayList;

import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

import com.clustercontrol.bean.TableColumnInfo;

/**
 * syslog-ng監視条件用テーブルビューワークラス
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class LogFilterInfoTableViewer extends TableViewer {

    /**
     * コンストラクタ
     * 
     * @param parent
     * @since 1.0.0
     */
    public LogFilterInfoTableViewer(Composite parent) {
        super(parent);
        setLabelProvider(new LogFilterInfoTableLabelProvider());
        setContentProvider(new ArrayContentProvider());
    }

    /**
     * コンストラクタ
     * 
     * @param parent
     * @param style
     * @since 1.0.0
     */
    public LogFilterInfoTableViewer(Composite parent, int style) {
        super(parent, style);
        setLabelProvider(new LogFilterInfoTableLabelProvider());
        setContentProvider(new ArrayContentProvider());
    }

    /**
     * コンストラクタ
     * 
     * @param table
     * @since 1.0.0
     */
    public LogFilterInfoTableViewer(Table table) {
        super(table);
        setLabelProvider(new LogFilterInfoTableLabelProvider());
        setContentProvider(new ArrayContentProvider());
    }

    /**
     * テーブルカラムの作成処理
     * 
     * @param tableColumnList
     * @since 1.0.0
     */
    public void createTableColumn(ArrayList tableColumnList) {

        for (int i = 0; i < tableColumnList.size(); i++) {
            TableColumnInfo tableColumnInfo = (TableColumnInfo) tableColumnList
                    .get(i);
            TableColumn column = new TableColumn(getTable(), tableColumnInfo
                    .getStyle(), i);
            column.setText(tableColumnInfo.getName());
            column.setWidth(tableColumnInfo.getWidth());
        }
    }
}