/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.syslogng.ejb.session;

import java.rmi.RemoteException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Locale;

import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.ejb.SessionContext;
import javax.naming.NamingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.swt.SWT;

import com.clustercontrol.bean.TableColumnInfo;
import com.clustercontrol.syslogng.bean.LogListTabelDefine;
import com.clustercontrol.syslogng.factory.ModifyMonitorRule;
import com.clustercontrol.syslogng.factory.SelectMonitorRule;
import com.clustercontrol.util.Messages;


/**
 *
 * <!-- begin-user-doc --> A generated session bean <!-- end-user-doc --> *
 *
 * <!-- begin-xdoclet-definition --> 
 * @ejb.bean name="SyslogNGController"	
 *           jndi-name="SyslogNGController"
 *           type="Stateless" 
 *           transaction-type="Container"
 * 
 * @jboss.depends name="jboss.j2ee:service=EJB,jndiName=AccessController"
 * @jboss.depends name="jboss.j2ee:service=EJB,jndiName=RepositoryController"
 * @jboss.depends name="jboss.j2ee:service=EJB,jndiName=MonitorController"
 * 
 * @ejb.permission
 *     unchecked="true"
 *     method-intf="Home"
 *     
 * @ejb.permission
 *     unchecked="true"
 *     method-intf="LocalHome"
 *     
 * @ejb.permission
 *     unchecked="true"
 *     method-intf="Local"
 * 
 * <!-- end-xdoclet-definition --> 
 * @generated
 */
public abstract class SyslogNGControllerBean implements javax.ejb.SessionBean {
	
	protected static Log m_log = LogFactory.getLog( SyslogNGControllerBean.class );
	
	@SuppressWarnings("unused")
	private SessionContext m_context;
	
	public void setSessionContext(SessionContext ctx) throws EJBException, RemoteException {
		m_context = ctx;
	}
	
	/**
	 * 監視条件テーブル定義取得
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     unchecked="true"
     *     method-intf="Remote"
	 * 
	 * @param local
	 * @return TableColumnInfoの配列
	 */
	@SuppressWarnings("unchecked")
	public ArrayList getLogFilterListTableDefine(Locale locale) {
		
		//テーブル定義配列
		ArrayList tableDefine = new ArrayList();
		
		tableDefine.add(LogListTabelDefine.ORDER_NO,
				new TableColumnInfo(Messages.getString("order", locale), TableColumnInfo.NONE, 50, SWT.RIGHT));
		tableDefine.add(LogListTabelDefine.PROCESS_TYPE,
				new TableColumnInfo(Messages.getString("process", locale), TableColumnInfo.PROCESS, 50, SWT.LEFT));		
		tableDefine.add(LogListTabelDefine.MONITOR_ID,
				new TableColumnInfo(Messages.getString("monitor.id", locale), TableColumnInfo.NONE, 100, SWT.LEFT));	
		tableDefine.add(LogListTabelDefine.DESCRIPTION, 
				new TableColumnInfo(Messages.getString("description", locale), TableColumnInfo.NONE, 200, SWT.LEFT));
		tableDefine.add(LogListTabelDefine.FACILITY_ID, 
				new TableColumnInfo(Messages.getString("scope", locale), TableColumnInfo.FACILITY, 200, SWT.LEFT));
		tableDefine.add(LogListTabelDefine.CALENDAR_ID, 
				new TableColumnInfo(Messages.getString("calendar", locale), TableColumnInfo.NONE, 100, SWT.LEFT));
		tableDefine.add(LogListTabelDefine.VALID_FLG, 
				new TableColumnInfo(Messages.getString("valid", locale) + "/" + Messages.getString("invalid", locale), TableColumnInfo.VALID, 80, SWT.LEFT));
		tableDefine.add(LogListTabelDefine.CREATE_USER, 
				new TableColumnInfo(Messages.getString("creator.name", locale), TableColumnInfo.NONE, 80, SWT.LEFT));
		tableDefine.add(LogListTabelDefine.CREATE_TIME, 
				new TableColumnInfo(Messages.getString("create.time", locale), TableColumnInfo.NONE, 130, SWT.LEFT));
		tableDefine.add(LogListTabelDefine.UPDATE_USER, 
				new TableColumnInfo(Messages.getString("modifier.name", locale), TableColumnInfo.NONE, 80, SWT.LEFT));
		tableDefine.add(LogListTabelDefine.UPDATE_TIME, 
				new TableColumnInfo(Messages.getString("update.time", locale), TableColumnInfo.NONE, 130, SWT.LEFT));
		
		return tableDefine;
	}
	
	/**
	 * 監視条件一覧取得
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     role-name="SyslogNgMonitorRead"
     *     method-intf="Remote"
	 * 
	 * @return
	 * @throws CreateException
	 * @throws FinderException
	 * @throws NamingException
	 */
	public ArrayList getFilterInfoList() throws CreateException, FinderException, NamingException {
		
	    SelectMonitorRule select = new SelectMonitorRule();
	    return select.getFilterInfoList();
	}

	/**
	 * 監視条件登録
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     role-name="SyslogNgMonitorWrite"
     *     method-intf="Remote"
	 * 
	 * @return
	 * @throws CreateException
	 * @throws FinderException
	 * @throws NamingException
	 */
	public boolean createMonitorRuleList(ArrayList filterInfo) throws CreateException, RemoveException, FinderException, NamingException {
		
		Principal pri = m_context.getCallerPrincipal();

		ModifyMonitorRule modify = new ModifyMonitorRule();
		
		// 監視条件削除 
		modify.deleteMonitorRule();
		// 監視条件登録
	    return modify.createMonitorRule(filterInfo, pri.getName());
	}
}
