/*
 
 Copyright (C) 2006 NTT DATA Corporation
 
 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License 
 as published by the Free Software Foundation, version 2.
 
 This program is distributed in the hope that it will be
 useful, but WITHOUT ANY WARRANTY; without even the implied 
 warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 PURPOSE.  See the GNU General Public License for more details.
 
 */

package com.clustercontrol.syslogng.ejb.entity;

import java.sql.Timestamp;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;


/**
 *
 * <!-- begin-user-doc --> You can insert your documentation for '<em><b>SyslogMonitorRuleBean</b></em>'. <!-- end-user-doc --> *
 *
 * <!-- begin-xdoclet-definition -->
 * @ejb.bean name="SyslogMonitorRule"
 *	jndi-name="SyslogMonitorRule"
 *	type="CMP"
 *  primkey-field="orderNo" 
 *  schema="SyslogMonitorRule" 
 *  cmp-version="2.x"
 *  data-source="java:/HinemosDS"
 * 
 * @jboss.depends name="jboss.jca:service=DataSourceBinding,name=HinemosDS"
 * 
 * @ejb.permission
 *     unchecked="true"
 * 
 *  @ejb.persistence 
 *   table-name="cc_syslog_monitor_rule" 
 * 
 * @ejb.finder 
 *    query="SELECT OBJECT(a) FROM SyslogMonitorRule as a"  
 *    signature="java.util.Collection findAll()"
 * 
 * @ejb.finder
 *    query=""
 *    signature="java.util.Collection findAllByOrderNoOrder()"
 * @jboss.query
 *    query="SELECT OBJECT(a) FROM SyslogMonitorRule as a ORDER BY a.orderNo"
 *    signature="java.util.Collection findAllByOrderNoOrder()"  
 *
 * @ejb.pk class="java.lang.Integer"
 * <!-- end-xdoclet-definition -->
 * @generated
 **/
public abstract class SyslogMonitorRuleBean implements javax.ejb.EntityBean {
	
	protected static Log m_log = LogFactory.getLog( SyslogMonitorRuleBean.class );
	
	/**
	 *
	 * <!-- begin-user-doc -->
	 * The  ejbCreate method.
	 * <!-- end-user-doc -->
	 *
	 * <!-- begin-xdoclet-definition --> 
	 * @ejb.create-method 
	 * <!-- end-xdoclet-definition --> 
	 * @generated
	 */
	public java.lang.Integer ejbCreate(
			Integer orderNo,
			String description,
			String facilityId,
			String pattern,
			Integer processType,
			Integer priority,
			String monitorId,
			String application,
			String messageId,
			String message,
			String notifyId,
			String calendarId,
			Integer jobRun,
			String jobId,
			Integer jobInhibitionFlg,
			Integer jobFailurePriority,
			Integer validFlg,
			Timestamp regDate,
			Timestamp updateDate,
			String regUser, 
			String updateUser) throws javax.ejb.CreateException {
		
		this.setOrderNo(orderNo);
		this.setDescription(description);
		this.setFacilityId(facilityId);
		this.setPattern(pattern);
		this.setProcessType(processType);
		this.setPriority(priority);
		this.setMonitorId(monitorId);
		this.setApplication(application);
		this.setMessageId(messageId);
		this.setMessage(message);
		this.setNotifyId(notifyId);
		this.setCalendarId(calendarId);
		this.setJobRun(jobRun);
		this.setJobId(jobId);
		this.setJobInhibitionFlg(jobInhibitionFlg);
		this.setJobFailurePriority(jobFailurePriority);
		this.setValidFlg(validFlg);
		this.setRegDate(regDate);
		this.setUpdateDate(updateDate);
		this.setRegUser(regUser);
		this.setUpdateUser(updateUser);
		
		return null;
	}
	
	/**
	 * <!-- begin-user-doc -->
	 * The container invokes this method immediately after it calls ejbCreate.
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public void ejbPostCreate() throws javax.ejb.CreateException {
		// begin-user-code
		// end-user-code
	}
	
	/**
	 *
	 *
	 * <!-- begin-user-doc -->
	 * CMP Field orderNo
	 *
	 * Returns the orderNo
	 * @return the orderNo
	 * 
	 * <!-- end-user-doc -->
	 *
	 * <!-- begin-xdoclet-definition --> 
	 *
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="order_no"
	 *     jdbc-type="SMALLINT"
	 *     sql-type="SMALLINT"
	 *     read-only="false"
	 * @ejb.pk-field 
	 *
	 * @ejb.interface-method
	 * 
	 * <!-- end-xdoclet-definition --> 
	 * @generated
	 */
	public abstract java.lang.Integer getOrderNo();
	
	/**
	 * <!-- begin-user-doc -->
	 * Sets the orderNo
	 * 
	 * @param java.lang.Integer the new orderNo value
	 * <!-- end-user-doc -->
	 * 
	 * <!-- begin-xdoclet-definition --> 
	 * @ejb.interface-method
	 * <!-- end-xdoclet-definition -->
	 * @generated 
	 */
	public abstract void setOrderNo(java.lang.Integer orderNo);
	
	/**
	 *
	 *
	 * <!-- begin-user-doc -->
	 * CMP Field description
	 *
	 * Returns the description
	 * @return the description
	 * 
	 * <!-- end-user-doc -->
	 *
	 * <!-- begin-xdoclet-definition --> 
	 *
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="description"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(256)"
	 *     read-only="false"
	 *  
	 *
	 * @ejb.interface-method
	 * 
	 * <!-- end-xdoclet-definition --> 
	 * @generated
	 */
	public abstract java.lang.String getDescription();
	
	/**
	 * <!-- begin-user-doc -->
	 * Sets the description
	 * 
	 * @param java.lang.String the new description value
	 * <!-- end-user-doc -->
	 * 
	 * <!-- begin-xdoclet-definition --> 
	 * @ejb.interface-method
	 * <!-- end-xdoclet-definition -->
	 * @generated 
	 */
	public abstract void setDescription(java.lang.String description);
	
	/**
	 *
	 *
	 * <!-- begin-user-doc -->
	 * CMP Field facilityId
	 *
	 * Returns the facilityId
	 * @return the facilityId
	 * 
	 * <!-- end-user-doc -->
	 *
	 * <!-- begin-xdoclet-definition --> 
	 *
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="facility_id"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(64)"
	 *     read-only="false"
	 *  
	 *
	 * @ejb.interface-method
	 * 
	 * <!-- end-xdoclet-definition --> 
	 * @generated
	 */
	public abstract java.lang.String getFacilityId();
	
	/**
	 * <!-- begin-user-doc -->
	 * Sets the facilityId
	 * 
	 * @param java.lang.String the new facilityId value
	 * <!-- end-user-doc -->
	 * 
	 * <!-- begin-xdoclet-definition --> 
	 * @ejb.interface-method
	 * <!-- end-xdoclet-definition -->
	 * @generated 
	 */
	public abstract void setFacilityId(java.lang.String facilityId);
	
	/**
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="job_failure_priority"
	 *     jdbc-type="SMALLINT"
	 *     sql-type="smallint"
	 *     read-only="false"
	 *  
	 * @ejb.interface-method
	 * 
	 * @return Returns the jobFailurePriority.
	 */
	public abstract Integer getJobFailurePriority();
	
	/**
	 * @ejb.interface-method
	 * 
	 * @param jobFailurePriority The jobFailurePriority to set.
	 */
	public abstract void setJobFailurePriority(Integer jobFailurePriority);
	
	/**
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="job_id"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(64)"
	 *     read-only="false"
	 *
	 * @ejb.interface-method
	 * 
	 * @return Returns the jobId.
	 */
	public abstract String getJobId();
	
	/**
	 * @ejb.interface-method
	 * 
	 * @param jobId The jobId to set.
	 */
	public abstract void setJobId(String jobId);
	
	/**
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="job_inhibition_flg"
	 *     jdbc-type="SMALLINT"
	 *     sql-type="smallint"
	 *     read-only="false"
	 *  
	 * @ejb.interface-method
	 * 
	 * @return Returns the jobInhibitionFlg.
	 */
	public abstract Integer getJobInhibitionFlg();
	
	/**
	 * @ejb.interface-method
	 * 
	 * @param jobInhibitionFlg The jobInhibitionFlg to set.
	 */
	public abstract void setJobInhibitionFlg(Integer jobInhibitionFlg);
	
	/**
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="job_run"
	 *     jdbc-type="SMALLINT"
	 *     sql-type="smallint"
	 *     read-only="false"
	 *  
	 * @ejb.interface-method
	 * 
	 * @return Returns the jobRun.
	 */
	public abstract Integer getJobRun();
	
	/**
	 * @ejb.interface-method
	 * 
	 * @param jobRun The jobRun to set.
	 */
	public abstract void setJobRun(Integer jobRun);
	
	/**
	 *
	 *
	 * <!-- begin-user-doc -->
	 * CMP Field pattern
	 *
	 * Returns the pattern
	 * @return the pattern
	 * 
	 * <!-- end-user-doc -->
	 *
	 * <!-- begin-xdoclet-definition --> 
	 *
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="pattern"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(256)"
	 *     read-only="false"
	 *  
	 *
	 * @ejb.interface-method
	 * 
	 * <!-- end-xdoclet-definition --> 
	 * @generated
	 */
	public abstract java.lang.String getPattern();
	
	/**
	 * <!-- begin-user-doc -->
	 * Sets the pattern
	 * 
	 * @param java.lang.String the new pattern value
	 * <!-- end-user-doc -->
	 * 
	 * <!-- begin-xdoclet-definition --> 
	 * @ejb.interface-method
	 * <!-- end-xdoclet-definition -->
	 * @generated 
	 */
	public abstract void setPattern(java.lang.String pattern);
	
	/**
	 *
	 *
	 * <!-- begin-user-doc -->
	 * CMP Field processType
	 *
	 * Returns the processType
	 * @return the processType
	 * 
	 * <!-- end-user-doc -->
	 *
	 * <!-- begin-xdoclet-definition --> 
	 *
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="process_type"
	 *     jdbc-type="SMALLINT"
	 *     sql-type="SMALLINT"
	 *     read-only="false"
	 *  
	 *
	 * @ejb.interface-method
	 * 
	 * <!-- end-xdoclet-definition --> 
	 * @generated
	 */
	public abstract java.lang.Integer getProcessType();
	
	/**
	 * <!-- begin-user-doc -->
	 * Sets the processType
	 * 
	 * @param java.lang.Integer the new processType value
	 * <!-- end-user-doc -->
	 * 
	 * <!-- begin-xdoclet-definition --> 
	 * @ejb.interface-method
	 * <!-- end-xdoclet-definition -->
	 * @generated 
	 */
	public abstract void setProcessType(java.lang.Integer processType);
	
	/**
	 *
	 *
	 * <!-- begin-user-doc -->
	 * CMP Field priority
	 *
	 * Returns the priority
	 * @return the priority
	 * 
	 * <!-- end-user-doc -->
	 *
	 * <!-- begin-xdoclet-definition --> 
	 *
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="priority"
	 *     jdbc-type="SMALLINT"
	 *     sql-type="SMALLINT"
	 *     read-only="false"
	 *  
	 *
	 * @ejb.interface-method
	 * 
	 * <!-- end-xdoclet-definition --> 
	 * @generated
	 */
	public abstract java.lang.Integer getPriority();
	
	/**
	 * <!-- begin-user-doc -->
	 * Sets the priority
	 * 
	 * @param java.lang.Integer the new priority value
	 * <!-- end-user-doc -->
	 * 
	 * <!-- begin-xdoclet-definition --> 
	 * @ejb.interface-method
	 * <!-- end-xdoclet-definition -->
	 * @generated 
	 */
	public abstract void setPriority(java.lang.Integer priority);
	
	/**
	 *
	 *
	 * <!-- begin-user-doc -->
	 * CMP Field monitorId
	 *
	 * Returns the monitorId
	 * @return the monitorId
	 * 
	 * <!-- end-user-doc -->
	 *
	 * <!-- begin-xdoclet-definition --> 
	 *
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="monitor_id"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(64)"
	 *     read-only="false"
	 *  
	 *
	 * @ejb.interface-method
	 * 
	 * <!-- end-xdoclet-definition --> 
	 * @generated
	 */
	public abstract java.lang.String getMonitorId();
	
	/**
	 * <!-- begin-user-doc -->
	 * Sets the monitorId
	 * 
	 * @param java.lang.String the new monitorId value
	 * <!-- end-user-doc -->
	 * 
	 * <!-- begin-xdoclet-definition --> 
	 * @ejb.interface-method
	 * <!-- end-xdoclet-definition -->
	 * @generated 
	 */
	public abstract void setMonitorId(java.lang.String monitorId);
	
	/**
	 *
	 *
	 * <!-- begin-user-doc -->
	 * CMP Field application
	 *
	 * Returns the application
	 * @return the application
	 * 
	 * <!-- end-user-doc -->
	 *
	 * <!-- begin-xdoclet-definition --> 
	 *
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="application"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(64)"
	 *     read-only="false"
	 *  
	 *
	 * @ejb.interface-method
	 * 
	 * <!-- end-xdoclet-definition --> 
	 * @generated
	 */
	public abstract java.lang.String getApplication();
	
	/**
	 * <!-- begin-user-doc -->
	 * Sets the application
	 * 
	 * @param java.lang.String the new application value
	 * <!-- end-user-doc -->
	 * 
	 * <!-- begin-xdoclet-definition --> 
	 * @ejb.interface-method
	 * <!-- end-xdoclet-definition -->
	 * @generated 
	 */
	public abstract void setApplication(java.lang.String application);
	
	/**
	 *
	 *
	 * <!-- begin-user-doc -->
	 * CMP Field messageId
	 *
	 * Returns the messageId
	 * @return the messageId
	 * 
	 * <!-- end-user-doc -->
	 *
	 * <!-- begin-xdoclet-definition --> 
	 *
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="message_id"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(64)"
	 *     read-only="false"
	 *  
	 *
	 * @ejb.interface-method
	 * 
	 * <!-- end-xdoclet-definition --> 
	 * @generated
	 */
	public abstract java.lang.String getMessageId();
	
	/**
	 * <!-- begin-user-doc -->
	 * Sets the messageId
	 * 
	 * @param java.lang.String the new messageId value
	 * <!-- end-user-doc -->
	 * 
	 * <!-- begin-xdoclet-definition --> 
	 * @ejb.interface-method
	 * <!-- end-xdoclet-definition -->
	 * @generated 
	 */
	public abstract void setMessageId(java.lang.String messageId);
	
	/**
	 *
	 *
	 * <!-- begin-user-doc -->
	 * CMP Field message
	 *
	 * Returns the message
	 * @return the message
	 * 
	 * <!-- end-user-doc -->
	 *
	 * <!-- begin-xdoclet-definition --> 
	 *
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="message"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(256)"
	 *     read-only="false"
	 *  
	 *
	 * @ejb.interface-method
	 * 
	 * <!-- end-xdoclet-definition --> 
	 * @generated
	 */
	public abstract java.lang.String getMessage();
	
	/**
	 * <!-- begin-user-doc -->
	 * Sets the message
	 * 
	 * @param java.lang.String the new message value
	 * <!-- end-user-doc -->
	 * 
	 * <!-- begin-xdoclet-definition --> 
	 * @ejb.interface-method
	 * <!-- end-xdoclet-definition -->
	 * @generated 
	 */
	public abstract void setMessage(java.lang.String message);
	
	/**
	 *
	 *
	 * <!-- begin-user-doc -->
	 * CMP Field notifyId
	 *
	 * Returns the notifyId
	 * @return the notifyId
	 * 
	 * <!-- end-user-doc -->
	 *
	 * <!-- begin-xdoclet-definition --> 
	 *
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="notify_id"
	 *    jdbc-type="VARCHAR"
	 *    sql-type="VARCHAR(64)"
	 *    read-only="false"
	 *  
	 *
	 * @ejb.interface-method
	 * 
	 * <!-- end-xdoclet-definition --> 
	 * @generated
	 */
	public abstract java.lang.String getNotifyId();
	
	/**
	 * <!-- begin-user-doc -->
	 * Sets the notifyId
	 * 
	 * @param java.lang.Integer the new notifyId value
	 * <!-- end-user-doc -->
	 * 
	 * <!-- begin-xdoclet-definition --> 
	 * @ejb.interface-method
	 * <!-- end-xdoclet-definition -->
	 * @generated 
	 */
	public abstract void setNotifyId(java.lang.String notifyId);
	
	/**
	 *
	 *
	 * <!-- begin-user-doc -->
	 * CMP Field validFlg
	 *
	 * Returns the validFlg
	 * @return the validFlg
	 * 
	 * <!-- end-user-doc -->
	 *
	 * <!-- begin-xdoclet-definition --> 
	 *
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="valid_flg"
	 *     jdbc-type="SMALLINT"
	 *     sql-type="SMALLINT"
	 *     read-only="false"
	 *  
	 *
	 * @ejb.interface-method
	 * 
	 * <!-- end-xdoclet-definition --> 
	 * @generated
	 */
	public abstract java.lang.Integer getValidFlg();
	
	/**
	 * <!-- begin-user-doc -->
	 * Sets the validFlg
	 * 
	 * @param java.lang.Integer the new validFlg value
	 * <!-- end-user-doc -->
	 * 
	 * <!-- begin-xdoclet-definition --> 
	 * @ejb.interface-method
	 * <!-- end-xdoclet-definition -->
	 * @generated 
	 */
	public abstract void setValidFlg(java.lang.Integer validFlg);
	
	/**
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="reg_date"
	 *     jdbc-type="TIMESTAMP"
	 *     sql-type="TIMESTAMP"
	 *     read-only="false"
	 *  
	 * @ejb.interface-method
	 * 
	 * @param regDate The regDate to set.
	 */
	public abstract Timestamp getRegDate();
	
	/**
	 * @ejb.interface-method
	 * 
	 * @param regDate The regDate to set.
	 */
	public abstract void setRegDate(Timestamp regDate);
	
	/**
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="reg_user"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR"
	 *     read-only="false"
	 *
	 * @ejb.interface-method
	 * 
	 * @return the regUser
	 */
	public abstract java.lang.String getRegUser();
	   
	/**
	 * @ejb.interface-method
	 * 
	 * @param java.lang.String the new regUser value
	 */
	public abstract void setRegUser(java.lang.String regUser);
	
	/**
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="update_date"
	 *     jdbc-type="TIMESTAMP"
	 *     sql-type="TIMESTAMP"
	 *     read-only="false"
	 *  
	 * @ejb.interface-method
	 * 
	 * @param updateDate The updateDate to set.
	 */
	public abstract Timestamp getUpdateDate();
	
	/**
	 * @ejb.interface-method
	 * 
	 * @param updateDate The updateDate to set.
	 */
	public abstract void setUpdateDate(Timestamp updateDate);
	
	/**
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="update_user"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR"
	 *     read-only="false"
	 *
	 * @ejb.interface-method
	 * 
	 * @return the updateUser
	 */
	public abstract java.lang.String getUpdateUser();
	   
	/**
	 * @ejb.interface-method
	 * 
	 * @param java.lang.String the new update_user value
	 */
	public abstract void setUpdateUser(java.lang.String updateUser);
	
	/**
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="calendar_id"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR"
	 *     read-only="false"
	 *
	 * @ejb.interface-method
	 */
	public abstract java.lang.String getCalendarId();
	
	/**
	 * @ejb.interface-method
	 * 
	 * @param java.lang.String the new calendar_id value
	 */
	public abstract void setCalendarId(String calendarId);
	
}
