/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.syslogng.bean;

import java.io.Serializable;
import java.util.Date;

import com.clustercontrol.bean.PriorityConstant;
import com.clustercontrol.bean.ProcessConstant;
import com.clustercontrol.bean.YesNoConstant;

/**
 * syslog-ngフィルタ情報を保持するクラスです。
 *
 * @version 2.1.0
 * @since 1.0.0
 */
public class LogFilterInfo implements Serializable {

	private static final long serialVersionUID = -544655198328111919L;

	//ロットID
    private String m_logId = null;

    //優先順
    private int m_orderNo = Integer.MAX_VALUE;

    //説明
    private String m_description = null;

    //スコープ
    private String m_scope = null;

    //ファシリティID
    private String m_facilityId = null;

    //検索パターン
    private String m_pattern = null;

    //処理タイプ
    private int m_processType = ProcessConstant.TYPE_YES;

    //重要度
    private int m_priority = PriorityConstant.TYPE_CRITICAL;

    //監視項目ID
    private String m_monitorId = null;

    //アプリケーション名
    private String m_application = null;

    //メッセージID
    private String m_messageId = null;

    //ログメッセージ
    private String m_message = null;
    
    //カレンダID
    private String m_calendarId = null;
    
    //通知ID
    private String m_notifyId = null;

    //有効フラグ
    private boolean m_validFlg = true;
    
    //登録日時
    private Date m_regDate = null;
    
    //更新日時
    private Date m_updateDate = null;
    
    /** ジョブ実行 @version 2.1.0 */
    private int m_jobRun = YesNoConstant.TYPE_NO;
	
	/** ジョブID @version 2.1.0 */
    private String m_jobId;
	
	/** ジョブ実行 通知抑制連動 @version 2.1.0 */
    private int m_jobInhibitionFlg = YesNoConstant.TYPE_NO;
	
	/** ジョブ呼び出し失敗時重要度 @version 2.1.0 */
    private int m_jobFailurePriority = PriorityConstant.TYPE_UNKNOWN;
    
    /** 新規作成ユーザ @since 2.1.0 */
	protected String m_regUser;
	
	/** 最終変更ユーザ @since 2.1.0 */
	protected String m_updateUser;

    /**
     *  
     */
    public LogFilterInfo() {
        super();
    }

    /**
     * コンストラクタ
     * 
     * @param orderNo
     * @param description
     * @param facilityId
     * @param pattern
     * @param processType
     * @param priority
     * @param monitorId
     * @param application
     * @param messageId
     * @param message
     * @param notifyId
     * @param jobRun
     * @param jobId
     * @param jobInhibitionFlg
     * @param jobFailurePriority
     * @param validFlg
     * @param regDate
     * @param updateDate
     * @param regUser
     * @param updateUser
     */
    public LogFilterInfo(
    		int orderNo, 
    		String description, 
    		String facilityId,
            String pattern, 
            int processType, 
            int priority, 
            String monitorId,
            String application, 
            String messageId, 
            String message,
            String notifyId, 
            int jobRun, 
			String jobId, 
			int jobInhibitionFlg, 
			int jobFailurePriority, 
            boolean validFlg, 
            Date regDate, 
            Date updateDate,
            String regUser,
            String updateUser) {
    	
        super();
        m_orderNo = orderNo;
        m_description = description;
        m_facilityId = facilityId;
        m_pattern = pattern;
        m_processType = processType;
        m_priority = priority;
        m_monitorId = monitorId;
        m_application = application;
        m_messageId = messageId;
        m_message = message;
        m_notifyId = notifyId;
        m_jobRun = jobRun;
        m_jobId = jobId;
        m_jobInhibitionFlg = jobInhibitionFlg;
        m_jobFailurePriority = jobFailurePriority;
        m_validFlg = validFlg;
        m_regDate = regDate;
        m_updateDate = updateDate;
        m_regUser = regUser;
        m_updateUser = updateUser;
    }

    /**
     * @return application を戻します。
     */
    public String getApplication() {
        return m_application;
    }

    /**
     * @param application
     *            application を設定。
     */
    public void setApplication(String application) {
        m_application = application;
    }

    /**
     * @return description を戻します。
     */
    public String getDescription() {
        return m_description;
    }

    /**
     * @param description
     *            description を設定。
     */
    public void setDescription(String description) {
        m_description = description;
    }

    /**
     * @return facilityId を戻します。
     */
    public String getFacilityId() {
        return m_facilityId;
    }

    /**
     * @param facilityId
     *            facilityId を設定。
     */
    public void setFacilityId(String facilityId) {
        m_facilityId = facilityId;
    }

    /**
     * @return message を戻します。
     */
    public String getMessage() {
        return m_message;
    }

    /**
     * @param message
     *            message を設定。
     */
    public void setMessage(String message) {
        m_message = message;
    }

    /**
     * @return messageId を戻します。
     */
    public String getMessageId() {
        return m_messageId;
    }

    /**
     * @param messageId
     *            messageId を設定。
     */
    public void setMessageId(String messageId) {
        m_messageId = messageId;
    }

    /**
     * @return moniterId を戻します。
     */
    public String getMonitorId() {
        return m_monitorId;
    }

    /**
     * @param monitorId
     *            monitorId を設定。
     */
    public void setMonitorId(String monitorId) {
        m_monitorId = monitorId;
    }

    /**
     * @return orderNo を戻します。
     */
    public int getOrderNo() {
        return m_orderNo;
    }

    /**
     * @param orderNo
     *            orderNo を設定。
     */
    public void setOrderNo(int orderNo) {
        m_orderNo = orderNo;
    }

    /**
     * @return pattern を戻します。
     */
    public String getPattern() {
        return m_pattern;
    }

    /**
     * @param pattern
     *            pattern を設定。
     */
    public void setPattern(String pattern) {
        m_pattern = pattern;
    }

    /**
     * @return priority を戻します。
     */
    public int getPriority() {
        return m_priority;
    }

    /**
     * @param priority
     *            priority を設定。
     */
    public void setPriority(int priority) {
        m_priority = priority;
    }

    /**
     * @return processType を戻します。
     */
    public int getProcessType() {
        return m_processType;
    }

    /**
     * @param processType
     *            processType を設定。
     */
    public void setProcessType(int processType) {
        m_processType = processType;
    }

    public boolean isValidFlg() {
        return m_validFlg;
    }

    public void setValidFlg(boolean validFlg) {
        m_validFlg = validFlg;
    }

    /**
     * @return logId を戻します。
     */
    public String getLogId() {
        return this.m_logId;
    }

    /**
     * @param logId
     *            logId を設定。
     */
    public void setLogId(String logId) {
        this.m_logId = logId;
    }

    /**
     * @return scope を戻します。
     */
    public String getScope() {
        return m_scope;
    }

    /**
     * @param scope
     *            scope を設定。
     */
    public void setScope(String scope) {
        this.m_scope = scope;
    }

	/**
	 * @return m_notifyId を戻します。
	 * @since 2.0.0
	 */
	public String getNotifyId() {
		return m_notifyId;
	}

	/**
	 * @param id 設定する notifyId。
	 * @since 2.0.0
	 */
	public void setNotifyId(String id) {
		m_notifyId = id;
	}

	/**
	 * @return m_regDate を戻します。
	 * @since 2.0.0
	 */
	public Date getRegDate() {
		return m_regDate;
	}

	/**
	 * @param date 設定する m_regDate。
	 * @since 2.0.0
	 */
	public void setRegDate(Date date) {
		m_regDate = date;
	}

	/**
	 * @return m_updateDate を戻します。
	 * @since 2.0.0
	 */
	public Date getUpdateDate() {
		return m_updateDate;
	}

	/**
	 * @param date 設定する m_updateDate。
	 * @since 2.0.0
	 */
	public void setUpdateDate(Date date) {
		m_updateDate = date;
	}

	/**
	 * @return m_calendarId を戻します。
	 * @since 2.1.0
	 */
	public String getCalendarId() {
		return m_calendarId;
	}

	/**
	 * @param calendarId 設定する m_calendarId。
	 * @since 2.1.0
	 */
	public void setCalendarId(String calendarId) {
		this.m_calendarId = calendarId;
	}
	
	/**
	 * @return jobFailurePriority を戻します。
	 * @since 2.1.0
	 */
	public int getJobFailurePriority() {
		return m_jobFailurePriority;
	}
	
	/**
	 * @param jobFailurePriority 設定する jobFailurePriority。
	 * @since 2.1.0
	 */
	public void setJobFailurePriority(int jobFailurePriority) {
		this.m_jobFailurePriority = jobFailurePriority;
	}
	
	/**
	 * @return jobId を戻します。
	 * @since 2.1.0
	 */
	public String getJobId() {
		return m_jobId;
	}
	
	/**
	 * @param jobId 設定する jobId。
	 * @since 2.1.0
	 */
	public void setJobId(String jobId) {
		this.m_jobId = jobId;
	}
	
	/**
	 * @return jobInhibitionFlg を戻します。
	 * @since 2.1.0
	 */
	public int getJobInhibitionFlg() {
		return m_jobInhibitionFlg;
	}
	
	/**
	 * @param jobInhibitionFlg 設定する jobInhibitionFlg。
	 * @since 2.1.0
	 */
	public void setJobInhibitionFlg(int jobInhibitionFlg) {
		this.m_jobInhibitionFlg = jobInhibitionFlg;
	}
	
	/**
	 * @return jobRun を戻します。
	 * @since 2.1.0
	 */
	public int getJobRun() {
		return m_jobRun;
	}
	
	/**
	 * @param jobRun 設定する jobRun。
	 * @since 2.1.0
	 */
	public void setJobRun(int jobRun) {
		this.m_jobRun = jobRun;
	}
	
	/**
	 * @param m_regUser 設定する m_regUser。
	 * @since 2.1.0
	 */
	public String getRegUser() {
		return m_regUser;
	}
	
	/**
	 * @param m_regUser 設定する m_regUser。
	 * @since 2.1.0
	 */
	public void setRegUser(String user) {
		m_regUser = user;
	}
	
	/**
	 * @param m_updateUser 設定する m_updateUser。
	 * @since 2.1.0
	 */
	public String getUpdateUser() {
		return m_updateUser;
	}
	
	/**
	 * @param m_updateUser 設定する m_updateUser。
	 * @since 2.1.0
	 */
	public void setUpdateUser(String user) {
		m_updateUser = user;
	}
}